/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.CanonicalPathUtils;

public class CanonicalPathHandler
implements HttpHandler {
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;

    public CanonicalPathHandler() {
    }

    public CanonicalPathHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) {
        exchange.setCanonicalPath(CanonicalPathUtils.canonicalize(exchange.getRequestPath()));
        exchange.setRelativePath(CanonicalPathUtils.canonicalize(exchange.getRelativePath()));
        HttpHandlers.executeHandler(this.next, exchange);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public CanonicalPathHandler setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
        return this;
    }
}

