/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version00;

import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketException;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.core.protocol.version00.WebSocket00BinaryFrameSinkChannel;
import io.undertow.websockets.core.protocol.version00.WebSocket00BinaryFrameSourceChannel;
import io.undertow.websockets.core.protocol.version00.WebSocket00CloseFrameSinkChannel;
import io.undertow.websockets.core.protocol.version00.WebSocket00CloseFrameSourceChannel;
import io.undertow.websockets.core.protocol.version00.WebSocket00TextFrameSinkChannel;
import io.undertow.websockets.core.protocol.version00.WebSocket00TextFrameSourceChannel;
import java.nio.ByteBuffer;
import java.util.Set;
import org.xnio.Pool;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.PushBackStreamChannel;
import org.xnio.channels.StreamSinkChannel;

public class WebSocket00Channel
extends WebSocketChannel {
    public WebSocket00Channel(ConnectedStreamChannel channel, Pool<ByteBuffer> bufferPool, String wsUrl, Set<String> subProtocols) {
        super(channel, bufferPool, WebSocketVersion.V00, wsUrl, subProtocols, false);
    }

    @Override
    protected WebSocketChannel.PartialFrame receiveFrame(final WebSocketChannel.StreamSourceChannelControl streamSourceChannelControl) {
        return new WebSocketChannel.PartialFrame(){
            private boolean receivedClosingHandshake;
            private State state = State.FRAME_START;
            private StreamSourceFrameChannel channel;
            private long frameSize;
            private int lengthFieldSize;

            @Override
            public StreamSourceFrameChannel getChannel() {
                return this.channel;
            }

            @Override
            public void handle(ByteBuffer buffer, PushBackStreamChannel channel) throws WebSocketException {
                if (!buffer.hasRemaining()) {
                    return;
                }
                if (this.receivedClosingHandshake) {
                    buffer.clear();
                    return;
                }
                if (this.state == State.FRAME_START) {
                    if (buffer.remaining() < 1) {
                        return;
                    }
                    byte type = buffer.get();
                    this.state = (type & 0x80) == 128 ? State.NON_TEXT_FRAME : State.TEXT_FRAME;
                }
                switch (this.state) {
                    case NON_TEXT_FRAME: {
                        byte b;
                        if (buffer.remaining() < 1) {
                            return;
                        }
                        do {
                            b = buffer.get();
                            this.frameSize <<= 7;
                            this.frameSize |= (long)(b & 0x7F);
                            ++this.lengthFieldSize;
                            if (this.lengthFieldSize > 8) {
                                throw WebSocketMessages.MESSAGES.noLengthEncodedInFrame();
                            }
                            if (buffer.hasRemaining()) continue;
                            if ((b & 0x80) != 128) break;
                            return;
                        } while ((b & 0x80) == 128);
                        this.state = State.FRAME_SIZE_READ;
                    }
                    case FRAME_SIZE_READ: {
                        if (this.frameSize == 0L) {
                            this.receivedClosingHandshake = true;
                            this.channel = new WebSocket00CloseFrameSourceChannel(streamSourceChannelControl, channel, WebSocket00Channel.this);
                        } else {
                            this.channel = new WebSocket00BinaryFrameSourceChannel(streamSourceChannelControl, channel, WebSocket00Channel.this, this.frameSize);
                        }
                        return;
                    }
                    case TEXT_FRAME: {
                        this.channel = new WebSocket00TextFrameSourceChannel(streamSourceChannelControl, channel, WebSocket00Channel.this);
                        return;
                    }
                }
                throw new IllegalStateException();
            }

            @Override
            public boolean isDone() {
                return this.channel != null;
            }
        };
    }

    @Override
    protected StreamSinkFrameChannel createStreamSinkChannel(StreamSinkChannel channel, WebSocketFrameType type, long payloadSize) {
        switch (type) {
            case TEXT: {
                return new WebSocket00TextFrameSinkChannel(channel, this, payloadSize);
            }
            case BINARY: {
                return new WebSocket00BinaryFrameSinkChannel(channel, this, payloadSize);
            }
            case CLOSE: {
                if (payloadSize != 0L) {
                    throw WebSocketMessages.MESSAGES.payloadNotSupportedInCloseFrames();
                }
                return new WebSocket00CloseFrameSinkChannel(channel, this);
            }
        }
        throw WebSocketMessages.MESSAGES.unsupportedFrameType(type);
    }

    private static enum State {
        FRAME_START,
        TEXT_FRAME,
        NON_TEXT_FRAME,
        FRAME_SIZE_READ;

    }
}

