/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import java.util.Map;
import javax.servlet.SessionCookieConfig;

public class SessionCookieConfigImpl
implements SessionCookieConfig,
SessionConfig {
    public static final String DEFAULT_SESSION_ID = "JSESSIONID";
    private String name = "JSESSIONID";
    private String path = "/";
    private String domain;
    private boolean secure;
    private boolean httpOnly;
    private int maxAge;
    private String comment;

    @Override
    public String rewriteUrl(String originalUrl, Session session) {
        return originalUrl;
    }

    @Override
    public void setSessionId(HttpServerExchange exchange, String sessionId) {
        Cookie cookie = new CookieImpl(this.name, sessionId).setPath(this.path).setDomain(this.domain).setSecure(this.secure).setHttpOnly(this.httpOnly).setComment(this.comment);
        if (this.maxAge > 0) {
            cookie.setMaxAge(this.maxAge);
        }
        CookieImpl.addResponseCookie(exchange, cookie);
    }

    @Override
    public void clearSession(HttpServerExchange exchange, String sessionId) {
        CookieImpl cookie = new CookieImpl(this.name, sessionId).setPath(this.path).setDomain(this.domain).setSecure(this.secure).setHttpOnly(this.httpOnly).setMaxAge(0);
        CookieImpl.addResponseCookie(exchange, cookie);
    }

    @Override
    public String findSessionId(HttpServerExchange exchange) {
        Cookie sessionId;
        Map<String, Cookie> cookies = CookieImpl.getRequestCookies(exchange);
        if (cookies != null && (sessionId = cookies.get(this.name)) != null) {
            return sessionId.getValue();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @Override
    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public int getMaxAge() {
        return this.maxAge;
    }

    @Override
    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }
}

