/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.core.ManagedFilter;
import io.undertow.servlet.handlers.ServletAttachments;
import io.undertow.servlet.spec.AsyncContextImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class FilterHandler
implements HttpHandler {
    private final Map<DispatcherType, List<ManagedFilter>> filters;
    private final Map<DispatcherType, Boolean> asyncSupported;
    private final HttpHandler next;

    public FilterHandler(Map<DispatcherType, List<ManagedFilter>> filters, HttpHandler next) {
        this.next = next;
        this.filters = new HashMap<DispatcherType, List<ManagedFilter>>(filters);
        HashMap<DispatcherType, Boolean> asyncSupported = new HashMap<DispatcherType, Boolean>();
        for (Map.Entry<DispatcherType, List<ManagedFilter>> entry : filters.entrySet()) {
            boolean supported = true;
            for (ManagedFilter i : entry.getValue()) {
                if (i.getFilterInfo().isAsyncSupported()) continue;
                supported = false;
                break;
            }
            asyncSupported.put(entry.getKey(), supported);
        }
        this.asyncSupported = asyncSupported;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        List<ManagedFilter> filters;
        ServletAttachments servletAttachments = exchange.getAttachment(ServletAttachments.ATTACHMENT_KEY);
        ServletRequest request = servletAttachments.getServletRequest();
        ServletResponse response = servletAttachments.getServletResponse();
        DispatcherType dispatcher = servletAttachments.getDispatcherType();
        Boolean supported = this.asyncSupported.get((Object)dispatcher);
        if (supported != null && !supported.booleanValue()) {
            exchange.putAttachment(AsyncContextImpl.ASYNC_SUPPORTED, false);
        }
        if ((filters = this.filters.get((Object)dispatcher)) == null) {
            this.next.handleRequest(exchange);
        } else {
            FilterChainImpl filterChain = new FilterChainImpl(exchange, filters, this.next);
            filterChain.doFilter(request, response);
        }
    }

    private static class FilterChainImpl
    implements FilterChain {
        int location = 0;
        final HttpServerExchange exchange;
        final List<ManagedFilter> filters;
        final HttpHandler next;

        private FilterChainImpl(HttpServerExchange exchange, List<ManagedFilter> filters, HttpHandler next) {
            this.exchange = exchange;
            this.filters = filters;
            this.next = next;
        }

        @Override
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            ServletAttachments servletAttachments = this.exchange.getAttachment(ServletAttachments.ATTACHMENT_KEY);
            ServletRequest oldReq = servletAttachments.getServletRequest();
            ServletResponse oldResp = servletAttachments.getServletResponse();
            try {
                servletAttachments.setServletRequest(request);
                servletAttachments.setServletResponse(response);
                int index = this.location++;
                if (index >= this.filters.size()) {
                    this.next.handleRequest(this.exchange);
                } else {
                    this.filters.get(index).doFilter(request, response, this);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                --this.location;
                servletAttachments.setServletRequest(oldReq);
                servletAttachments.setServletResponse(oldResp);
            }
        }
    }
}

