/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OriginHandler
implements HttpHandler {
    private volatile HttpHandler originFailedHandler = ResponseCodeHandler.HANDLE_403;
    private volatile Set<String> allowedOrigins = new HashSet<String>();
    private volatile boolean requireAllOrigins = true;
    private volatile boolean requireOriginHeader = true;
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HeaderValues origin = exchange.getRequestHeaders().get(Headers.ORIGIN);
        if (origin == null) {
            if (this.requireOriginHeader) {
                if (UndertowLogger.REQUEST_LOGGER.isDebugEnabled()) {
                    UndertowLogger.REQUEST_LOGGER.debugf("Refusing request for %s due to lack of Origin: header", (Object)exchange.getRequestPath());
                }
                HttpHandlers.executeHandler(this.originFailedHandler, exchange);
                return;
            }
        } else {
            boolean found = false;
            boolean requireAllOrigins = this.requireAllOrigins;
            for (String header : origin) {
                if (this.allowedOrigins.contains(header)) {
                    found = true;
                    if (requireAllOrigins) continue;
                    break;
                }
                if (!requireAllOrigins) continue;
                if (UndertowLogger.REQUEST_LOGGER.isDebugEnabled()) {
                    UndertowLogger.REQUEST_LOGGER.debugf("Refusing request for %s due to Origin %s not being in the allowed origins list", (Object)exchange.getRequestPath(), (Object)header);
                }
                HttpHandlers.executeHandler(this.originFailedHandler, exchange);
                return;
            }
            if (!found) {
                if (UndertowLogger.REQUEST_LOGGER.isDebugEnabled()) {
                    UndertowLogger.REQUEST_LOGGER.debugf("Refusing request for %s as none of the specified origins %s were in the allowed origins list", (Object)exchange.getRequestPath(), (Object)origin);
                }
                HttpHandlers.executeHandler(this.originFailedHandler, exchange);
                return;
            }
        }
        HttpHandlers.executeHandler(this.next, exchange);
    }

    public synchronized OriginHandler addAllowedOrigin(String origin) {
        HashSet<String> allowedOrigins = new HashSet<String>(this.allowedOrigins);
        allowedOrigins.add(origin);
        this.allowedOrigins = Collections.unmodifiableSet(allowedOrigins);
        return this;
    }

    public synchronized OriginHandler addAllowedOrigins(Collection<String> origins) {
        HashSet<String> allowedOrigins = new HashSet<String>(this.allowedOrigins);
        allowedOrigins.addAll(origins);
        this.allowedOrigins = Collections.unmodifiableSet(allowedOrigins);
        return this;
    }

    public synchronized OriginHandler addAllowedOrigins(String ... origins) {
        HashSet<String> allowedOrigins = new HashSet<String>(this.allowedOrigins);
        allowedOrigins.addAll(Arrays.asList(origins));
        this.allowedOrigins = Collections.unmodifiableSet(allowedOrigins);
        return this;
    }

    public synchronized Set<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public synchronized OriginHandler clearAllowedOrigins() {
        this.allowedOrigins = Collections.emptySet();
        return this;
    }

    public boolean isRequireAllOrigins() {
        return this.requireAllOrigins;
    }

    public OriginHandler setRequireAllOrigins(boolean requireAllOrigins) {
        this.requireAllOrigins = requireAllOrigins;
        return this;
    }

    public boolean isRequireOriginHeader() {
        return this.requireOriginHeader;
    }

    public OriginHandler setRequireOriginHeader(boolean requireOriginHeader) {
        this.requireOriginHeader = requireOriginHeader;
        return this;
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public OriginHandler setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    public HttpHandler getOriginFailedHandler() {
        return this.originFailedHandler;
    }

    public OriginHandler setOriginFailedHandler(HttpHandler originFailedHandler) {
        HttpHandlers.handlerNotNull(originFailedHandler);
        this.originFailedHandler = originFailedHandler;
        return this;
    }
}

