/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.handlers.security.SecurityPathMatch;
import io.undertow.servlet.handlers.security.SecurityPathMatches;
import io.undertow.servlet.handlers.security.SingleConstraintMatch;
import java.util.ArrayList;
import java.util.List;

public class ServletSecurityConstraintHandler
implements HttpHandler {
    private final SecurityPathMatches securityPathMatches;
    private final HttpHandler next;

    public ServletSecurityConstraintHandler(SecurityPathMatches securityPathMatches, HttpHandler next) {
        this.securityPathMatches = securityPathMatches;
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String path = exchange.getRelativePath();
        SecurityPathMatch securityMatch = this.securityPathMatches.getSecurityInfo(path, exchange.getRequestMethod().toString());
        ServletRequestContext servletRequestContext = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        List<SingleConstraintMatch> list = servletRequestContext.getRequiredConstrains();
        if (list == null) {
            list = new ArrayList<SingleConstraintMatch>();
            servletRequestContext.setRequiredConstrains(list);
        }
        list.addAll(securityMatch.getRequiredConstraints());
        TransportGuaranteeType type = servletRequestContext.getTransportGuarenteeType();
        if (type == null || type.ordinal() < securityMatch.getTransportGuaranteeType().ordinal()) {
            servletRequestContext.setTransportGuarenteeType(securityMatch.getTransportGuaranteeType());
        }
        this.next.handleRequest(exchange);
    }
}

