/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowMessages;
import io.undertow.server.handlers.resource.FileResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.File;

public class FileResourceManager
implements ResourceManager {
    private volatile File base;

    public FileResourceManager(File base) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        this.base = base;
    }

    public File getBase() {
        return this.base;
    }

    public FileResourceManager setBase(File base) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        this.base = base;
        return this;
    }

    @Override
    public Resource getResource(String p) {
        File file;
        String path = p;
        if (File.separatorChar != '/') {
            if (path.indexOf(File.separatorChar) != -1) {
                return null;
            }
            path = path.replace('/', File.separatorChar);
        }
        if ((file = new File(this.base, path)).exists()) {
            return new FileResource(file);
        }
        return null;
    }
}

