/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class RequestHeaderContainsPredicate
implements Predicate {
    private final HttpString header;
    private final String[] values;

    RequestHeaderContainsPredicate(String header, String[] values) {
        this.header = new HttpString(header);
        this.values = new String[values.length];
        System.arraycopy(values, 0, this.values, 0, values.length);
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        HeaderValues headers = value.getRequestHeaders().get(this.header);
        if (headers == null) {
            return false;
        }
        for (String header : headers) {
            for (int i = 0; i < this.values.length; ++i) {
                if (!header.contains(this.values[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "requestHeaderContains";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("value", String[].class);
            params.put("header", String.class);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            HashSet<String> params = new HashSet<String>();
            params.add("value");
            params.add("header");
            return params;
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            String[] values = (String[])config.get("value");
            String header = (String)config.get("header");
            return new RequestHeaderContainsPredicate(header, values);
        }
    }
}

