/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.api;

import io.undertow.server.HandlerWrapper;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.SecurityRoleRef;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.util.ConstructorInstanceFactory;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;

public class ServletInfo
implements Cloneable {
    private final Class<? extends Servlet> servletClass;
    private final String name;
    private final List<String> mappings = new ArrayList<String>();
    private final Map<String, String> initParams = new HashMap<String, String>();
    private final List<SecurityRoleRef> securityRoleRefs = new ArrayList<SecurityRoleRef>();
    private final List<HandlerWrapper> handlerChainWrappers = new ArrayList<HandlerWrapper>();
    private volatile InstanceFactory<? extends Servlet> instanceFactory;
    private volatile String jspFile;
    private volatile Integer loadOnStartup;
    private volatile boolean enabled;
    private volatile boolean asyncSupported;
    private volatile String runAs;
    private volatile MultipartConfigElement multipartConfig;
    private volatile ServletSecurityInfo servletSecurityInfo;

    public ServletInfo(String name, Class<? extends Servlet> servletClass) {
        if (name == null) {
            throw UndertowServletMessages.MESSAGES.paramCannotBeNull("name");
        }
        if (servletClass == null) {
            throw UndertowServletMessages.MESSAGES.paramCannotBeNull("servletClass", "Servlet", name);
        }
        if (!Servlet.class.isAssignableFrom(servletClass)) {
            throw UndertowServletMessages.MESSAGES.servletMustImplementServlet(name, servletClass);
        }
        try {
            Constructor<? extends Servlet> ctor = servletClass.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            this.instanceFactory = new ConstructorInstanceFactory<Servlet>(ctor);
            this.name = name;
            this.servletClass = servletClass;
        }
        catch (NoSuchMethodException e) {
            throw UndertowServletMessages.MESSAGES.componentMustHaveDefaultConstructor("Servlet", servletClass);
        }
    }

    public ServletInfo(String name, Class<? extends Servlet> servletClass, InstanceFactory<? extends Servlet> instanceFactory) {
        if (name == null) {
            throw UndertowServletMessages.MESSAGES.paramCannotBeNull("name");
        }
        if (servletClass == null) {
            throw UndertowServletMessages.MESSAGES.paramCannotBeNull("servletClass", "Servlet", name);
        }
        if (!Servlet.class.isAssignableFrom(servletClass)) {
            throw UndertowServletMessages.MESSAGES.servletMustImplementServlet(name, servletClass);
        }
        this.instanceFactory = instanceFactory;
        this.name = name;
        this.servletClass = servletClass;
    }

    public void validate() {
    }

    public ServletInfo clone() {
        ServletInfo info = new ServletInfo(this.name, this.servletClass, this.instanceFactory).setJspFile(this.jspFile).setLoadOnStartup(this.loadOnStartup).setEnabled(this.enabled).setAsyncSupported(this.asyncSupported).setRunAs(this.runAs).setMultipartConfig(this.multipartConfig);
        info.mappings.addAll(this.mappings);
        info.initParams.putAll(this.initParams);
        info.securityRoleRefs.addAll(this.securityRoleRefs);
        info.handlerChainWrappers.addAll(this.handlerChainWrappers);
        if (this.servletSecurityInfo != null) {
            info.servletSecurityInfo = this.servletSecurityInfo.clone();
        }
        return info;
    }

    public Class<? extends Servlet> getServletClass() {
        return this.servletClass;
    }

    public String getName() {
        return this.name;
    }

    public void setInstanceFactory(InstanceFactory<? extends Servlet> instanceFactory) {
        if (instanceFactory == null) {
            throw UndertowServletMessages.MESSAGES.paramCannotBeNull("instanceFactory");
        }
        this.instanceFactory = instanceFactory;
    }

    public InstanceFactory<? extends Servlet> getInstanceFactory() {
        return this.instanceFactory;
    }

    public List<String> getMappings() {
        return Collections.unmodifiableList(this.mappings);
    }

    public ServletInfo addMapping(String mapping) {
        this.mappings.add(mapping);
        return this;
    }

    public ServletInfo addMappings(Collection<String> mappings) {
        this.mappings.addAll(mappings);
        return this;
    }

    public ServletInfo addMappings(String ... mappings) {
        this.mappings.addAll(Arrays.asList(mappings));
        return this;
    }

    public ServletInfo addInitParam(String name, String value) {
        this.initParams.put(name, value);
        return this;
    }

    public Map<String, String> getInitParams() {
        return Collections.unmodifiableMap(this.initParams);
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public ServletInfo setJspFile(String jspFile) {
        this.jspFile = jspFile;
        return this;
    }

    public Integer getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public ServletInfo setLoadOnStartup(Integer loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
        return this;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public ServletInfo setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ServletInfo setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getRunAs() {
        return this.runAs;
    }

    public ServletInfo setRunAs(String runAs) {
        this.runAs = runAs;
        return this;
    }

    public MultipartConfigElement getMultipartConfig() {
        return this.multipartConfig;
    }

    public ServletInfo setMultipartConfig(MultipartConfigElement multipartConfig) {
        this.multipartConfig = multipartConfig;
        return this;
    }

    public void addSecurityRoleRef(String role, String linkedRole) {
        this.securityRoleRefs.add(new SecurityRoleRef(role, linkedRole));
    }

    public List<SecurityRoleRef> getSecurityRoleRefs() {
        return Collections.unmodifiableList(this.securityRoleRefs);
    }

    public ServletInfo addHandlerChainWrapper(HandlerWrapper wrapper) {
        this.handlerChainWrappers.add(wrapper);
        return this;
    }

    public List<HandlerWrapper> getHandlerChainWrappers() {
        return Collections.unmodifiableList(this.handlerChainWrappers);
    }

    public ServletSecurityInfo getServletSecurityInfo() {
        return this.servletSecurityInfo;
    }

    public ServletInfo setServletSecurityInfo(ServletSecurityInfo servletSecurityInfo) {
        this.servletSecurityInfo = servletSecurityInfo;
        return this;
    }
}

