/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.conduits.ConduitListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class FixedLengthStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private final ConduitListener<? super FixedLengthStreamSourceConduit> finishListener;
    private long state;
    private static final long FLAG_CLOSED = Long.MIN_VALUE;
    private static final long FLAG_FINISHED = 0x4000000000000000L;
    private static final long MASK_COUNT = Bits.longBitMask(0, 61);

    public FixedLengthStreamSourceConduit(StreamSourceConduit next, long contentLength, ConduitListener<? super FixedLengthStreamSourceConduit> finishListener) {
        super(next);
        this.finishListener = finishListener;
        if (contentLength < 0L) {
            throw new IllegalArgumentException("Content length must be greater than or equal to zero");
        }
        if (contentLength > MASK_COUNT) {
            throw new IllegalArgumentException("Content length is too long");
        }
        this.state = contentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        long val = this.state;
        if (Bits.anyAreSet(val, -4611686018427387904L) || Bits.allAreClear(val, MASK_COUNT)) {
            return 0L;
        }
        long res = 0L;
        try {
            long l = res = ((StreamSourceConduit)this.next).transferTo(position, Math.min(count, val), target);
            return l;
        }
        finally {
            this.exitRead(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        long res;
        long val;
        block5: {
            if (count == 0L) {
                return 0L;
            }
            val = this.state;
            if (Bits.anyAreSet(val, -4611686018427387904L) || Bits.allAreClear(val, MASK_COUNT)) {
                return -1L;
            }
            res = 0L;
            try {
                if (!Bits.allAreSet(val, Long.MIN_VALUE) && val != 0L) break block5;
                long l = -1L;
                this.exitRead(res == -1L ? val & MASK_COUNT : res);
                return l;
            }
            catch (Throwable throwable) {
                this.exitRead(res == -1L ? val & MASK_COUNT : res);
                throw throwable;
            }
        }
        long l = res = ((StreamSourceConduit)this.next).transferTo(Math.min(count, val), throughBuffer, target);
        this.exitRead(res == -1L ? val & MASK_COUNT : res);
        return l;
    }

    /*
     * Exception decompiling
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 4[CATCHBLOCK], 6[FORLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    /*
     * Exception decompiling
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void suspendReads() {
        long val = this.state;
        if (Bits.anyAreSet(val, -4611686018427387904L) || Bits.allAreClear(val, MASK_COUNT)) {
            return;
        }
        ((StreamSourceConduit)this.next).suspendReads();
    }

    @Override
    public void resumeReads() {
        long val = this.state;
        if (Bits.anyAreSet(val, -4611686018427387904L) || Bits.allAreClear(val, MASK_COUNT)) {
            return;
        }
        if (val == 0L) {
            ((StreamSourceConduit)this.next).wakeupReads();
        } else {
            ((StreamSourceConduit)this.next).resumeReads();
        }
    }

    @Override
    public boolean isReadResumed() {
        return Bits.allAreClear(this.state, Long.MIN_VALUE) && ((StreamSourceConduit)this.next).isReadResumed();
    }

    @Override
    public void wakeupReads() {
        long val = this.state;
        if (Bits.anyAreSet(val, -4611686018427387904L) || Bits.allAreClear(val, MASK_COUNT)) {
            return;
        }
        ((StreamSourceConduit)this.next).wakeupReads();
    }

    @Override
    public void terminateReads() throws IOException {
        long val = this.enterShutdownReads();
        if (Bits.allAreSet(val, Long.MIN_VALUE)) {
            return;
        }
        this.exitShutdownReads(val);
    }

    @Override
    public void awaitReadable() throws IOException {
        long val = this.state;
        if (Bits.allAreSet(val, Long.MIN_VALUE) || val == 0L) {
            return;
        }
        ((StreamSourceConduit)this.next).awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        long val = this.state;
        if (Bits.allAreSet(val, Long.MIN_VALUE) || val == 0L) {
            return;
        }
        ((StreamSourceConduit)this.next).awaitReadable(time, timeUnit);
    }

    public long getRemaining() {
        return this.state & MASK_COUNT;
    }

    private long enterShutdownReads() {
        long newVal;
        long oldVal = this.state;
        if (Bits.anyAreSet(oldVal, Long.MIN_VALUE)) {
            return oldVal;
        }
        this.state = newVal = oldVal | Long.MIN_VALUE;
        return oldVal;
    }

    private void exitShutdownReads(long oldVal) {
        if (!Bits.allAreClear(oldVal, MASK_COUNT)) {
            this.finishListener.handleEvent(this);
        }
    }

    private void exitRead(long consumed) {
        long newVal;
        long oldVal = this.state;
        this.state = newVal = oldVal - consumed;
        if (Bits.anyAreSet(oldVal, MASK_COUNT) && Bits.allAreClear(newVal, MASK_COUNT)) {
            this.finishListener.handleEvent(this);
        }
    }
}

