/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.examples.security.basic;

import io.undertow.Undertow;
import io.undertow.examples.UndertowExample;
import io.undertow.examples.security.basic.MapIdentityManager;
import io.undertow.io.IoCallback;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.HashMap;

@UndertowExample(value="Basic Authentication")
public class BasicAuthServer {
    public static void main(String[] args) {
        System.out.println("You can login with the following credentials:");
        System.out.println("User: userOne Password: passwordOne");
        System.out.println("User: userTwo Password: passwordTwo");
        HashMap<String, char[]> users = new HashMap<String, char[]>(2);
        users.put("userOne", "passwordOne".toCharArray());
        users.put("userTwo", "passwordTwo".toCharArray());
        MapIdentityManager identityManager = new MapIdentityManager(users);
        Undertow server = Undertow.builder().addListener(8080, "localhost").setDefaultHandler(new HttpHandler(){

            @Override
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                SecurityContext context = exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
                exchange.getResponseSender().send("Hello " + context.getAuthenticatedAccount().getPrincipal().getName(), IoCallback.END_EXCHANGE);
            }
        }).setLoginConfig(Undertow.loginConfig(identityManager).basicAuth("MyApp")).build();
        server.start();
    }
}

