/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.channels.ReadTimeoutStreamSourceChannel;
import io.undertow.channels.WriteTimeoutStreamSinkChannel;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpReadListener;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.OpenListener;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.channels.AssembledConnectedSslStreamChannel;
import org.xnio.channels.AssembledConnectedStreamChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.SslChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public final class HttpOpenListener
implements ChannelListener<ConnectedStreamChannel>,
OpenListener {
    private final Pool<ByteBuffer> bufferPool;
    private final int bufferSize;
    private volatile HttpHandler rootHandler;
    private volatile OptionMap undertowOptions;

    public HttpOpenListener(Pool<ByteBuffer> pool, int bufferSize) {
        this(pool, OptionMap.EMPTY, bufferSize);
    }

    public HttpOpenListener(Pool<ByteBuffer> pool, OptionMap undertowOptions, int bufferSize) {
        this.undertowOptions = undertowOptions;
        this.bufferPool = pool;
        this.bufferSize = bufferSize;
    }

    @Override
    public void handleEvent(ConnectedStreamChannel channel) {
        if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
            UndertowLogger.REQUEST_LOGGER.tracef("Opened connection with %s", (Object)channel.getPeerAddress());
        }
        StreamSourceChannel readChannel = channel;
        StreamSinkChannel writeChannel = channel;
        if (channel.supportsOption(Options.READ_TIMEOUT)) {
            readChannel = new ReadTimeoutStreamSourceChannel(readChannel);
        }
        if (channel.supportsOption(Options.WRITE_TIMEOUT)) {
            writeChannel = new WriteTimeoutStreamSinkChannel(writeChannel);
        }
        AssembledConnectedStreamChannel assembledChannel = channel instanceof SslChannel ? new AssembledConnectedSslStreamChannel((SslChannel)((Object)channel), readChannel, writeChannel) : new AssembledConnectedStreamChannel(channel, readChannel, writeChannel);
        HttpServerConnection connection = new HttpServerConnection(assembledChannel, this.bufferPool, this.rootHandler, this.undertowOptions, this.bufferSize);
        HttpReadListener readListener = new HttpReadListener(writeChannel, readChannel, connection);
        readChannel.getReadSetter().set(readListener);
        readListener.handleEvent(readChannel);
    }

    @Override
    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public void setRootHandler(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public void setUndertowOptions(OptionMap undertowOptions) {
        if (undertowOptions == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("undertowOptions");
        }
        this.undertowOptions = undertowOptions;
    }
}

