/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.server.HttpHandler;
import io.undertow.util.AbstractAttachable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSession;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.SslChannel;

public final class HttpServerConnection
extends AbstractAttachable
implements ConnectedChannel {
    private final ConnectedStreamChannel channel;
    private final ChannelListener.Setter<HttpServerConnection> closeSetter;
    private final Pool<ByteBuffer> bufferPool;
    private final HttpHandler rootHandler;
    private final OptionMap undertowOptions;
    private final int bufferSize;
    private Pooled<ByteBuffer> extraBytes;

    public HttpServerConnection(ConnectedStreamChannel channel, Pool<ByteBuffer> bufferPool, HttpHandler rootHandler, OptionMap undertowOptions, int bufferSize) {
        this.channel = channel;
        this.bufferPool = bufferPool;
        this.rootHandler = rootHandler;
        this.undertowOptions = undertowOptions;
        this.bufferSize = bufferSize;
        this.closeSetter = ChannelListeners.getDelegatingSetter(channel.getCloseSetter(), this);
    }

    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    public ConnectedStreamChannel getChannel() {
        return this.channel;
    }

    public ChannelListener.Setter<HttpServerConnection> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.channel.getIoThread();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.channel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.channel.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.channel.setOption(option, value);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.channel.getPeerAddress();
    }

    @Override
    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return this.channel.getPeerAddress(type);
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return this.channel.getLocalAddress(type);
    }

    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public SSLSession getSslSession() {
        if (this.channel instanceof SslChannel) {
            return ((SslChannel)((Object)this.channel)).getSslSession();
        }
        return null;
    }

    public Pooled<ByteBuffer> getExtraBytes() {
        return this.extraBytes;
    }

    public void setExtraBytes(Pooled<ByteBuffer> extraBytes) {
        this.extraBytes = extraBytes;
    }
}

