/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.channels;

import io.undertow.UndertowMessages;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class StreamSinkChannelFacade
implements StreamSinkChannel {
    private static final int WRITES_SHUTDOWN = 1;
    private static final int CLOSED = 2;
    protected final StreamSinkChannel delegate;
    protected final ChannelListener.SimpleSetter<StreamSinkChannelFacade> writeSetter = new ChannelListener.SimpleSetter();
    protected final ChannelListener.SimpleSetter<StreamSinkChannelFacade> closeSetter = new ChannelListener.SimpleSetter();
    private int state = 0;

    public StreamSinkChannelFacade(StreamSinkChannel delegate) {
        this.delegate = delegate;
        delegate.getWriteSetter().set(ChannelListeners.delegatingChannelListener(this, this.writeSetter));
        delegate.getCloseSetter().set(ChannelListeners.delegatingChannelListener(this, this.closeSetter));
    }

    @Override
    public void suspendWrites() {
        if (Bits.anyAreSet(this.state, 2)) {
            return;
        }
        this.delegate.suspendWrites();
    }

    @Override
    public void resumeWrites() {
        if (Bits.anyAreSet(this.state, 2)) {
            return;
        }
        this.delegate.resumeWrites();
    }

    @Override
    public boolean isWriteResumed() {
        if (Bits.anyAreSet(this.state, 2)) {
            return false;
        }
        return this.delegate.isWriteResumed();
    }

    @Override
    public void wakeupWrites() {
        if (Bits.anyAreSet(this.state, 2)) {
            return;
        }
        this.delegate.wakeupWrites();
    }

    @Override
    public void shutdownWrites() throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            return;
        }
        this.state |= 1;
        this.delegate.shutdownWrites();
    }

    @Override
    public void awaitWritable() throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        this.delegate.awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        this.delegate.awaitWritable(time, timeUnit);
    }

    @Override
    public XnioExecutor getWriteThread() {
        return this.delegate.getWriteThread();
    }

    @Override
    public boolean isOpen() {
        return !Bits.anyAreSet(this.state, 2);
    }

    @Override
    public void close() throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            return;
        }
        this.state |= 2;
        this.delegate.close();
    }

    @Override
    public boolean flush() throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        boolean res = this.delegate.flush();
        if (res && Bits.anyAreSet(this.state, 1)) {
            this.state |= 2;
        }
        return res;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        return this.delegate.transferFrom(src, position, count);
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        return this.delegate.transferFrom(source, count, throughBuffer);
    }

    @Override
    public ChannelListener.Setter<? extends StreamSinkChannel> getWriteSetter() {
        return this.writeSetter;
    }

    @Override
    public ChannelListener.Setter<? extends StreamSinkChannel> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.delegate.getIoThread();
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        return this.delegate.write(srcs, offset, length);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        return this.delegate.write(srcs);
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.delegate.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        return this.delegate.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        return this.delegate.setOption(option, value);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet(this.state, 2)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        return this.delegate.write(src);
    }
}

