/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.cache;

import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.cache.LimitedBufferSlicePool;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.Buffers;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.StreamSinkConduit;

public class ResponseCachingStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final DirectBufferCache.CacheEntry cacheEntry;
    private final long length;
    private long written;

    protected ResponseCachingStreamSinkConduit(StreamSinkConduit next, DirectBufferCache.CacheEntry cacheEntry, long length) {
        super(next);
        this.cacheEntry = cacheEntry;
        this.length = length;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer(source, count, throughBuffer, new ConduitWritableByteChannel(this));
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        LimitedBufferSlicePool.PooledByteBuffer[] pooled = this.cacheEntry.buffers();
        ByteBuffer[] buffers = new ByteBuffer[pooled.length];
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i] = pooled[i].getResource();
        }
        this.written += (long)Buffers.copy(buffers, 0, buffers.length, src.duplicate());
        for (ByteBuffer buffer : buffers) {
            buffer.flip();
        }
        return super.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        LimitedBufferSlicePool.PooledByteBuffer[] pooled = this.cacheEntry.buffers();
        ByteBuffer[] buffers = new ByteBuffer[pooled.length];
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i] = pooled[i].getResource();
        }
        ByteBuffer[] src = new ByteBuffer[srcs.length];
        for (int i = 0; i < srcs.length; ++i) {
            src[i] = srcs[i].duplicate();
        }
        this.written += Buffers.copy(buffers, 0, buffers.length, src, 0, src.length);
        for (ByteBuffer buffer : buffers) {
            buffer.flip();
        }
        return super.write(srcs, offs, len);
    }

    @Override
    public void terminateWrites() throws IOException {
        if (this.written == this.length) {
            this.cacheEntry.enable();
        } else {
            this.cacheEntry.disable();
            this.cacheEntry.dereference();
        }
        super.terminateWrites();
    }

    @Override
    public void truncateWrites() throws IOException {
        this.cacheEntry.disable();
        this.cacheEntry.dereference();
        super.truncateWrites();
    }
}

