/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.UndertowLogger;
import io.undertow.client.HttpClientCallback;
import io.undertow.client.HttpClientConnection;
import io.undertow.client.HttpClientImpl;
import io.undertow.client.HttpClientRequest;
import io.undertow.client.HttpClientRequestImpl;
import io.undertow.client.HttpClientResponse;
import io.undertow.client.HttpRequestQueueStrategy;
import io.undertow.client.HttpResponseParser;
import io.undertow.client.PendingHttpRequest;
import io.undertow.client.ResponseParseState;
import io.undertow.client.UndertowClientMessages;
import io.undertow.client.UpgradeHandshake;
import io.undertow.util.ConcreteIoFuture;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.AssembledConnectedStreamChannel;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.PushBackStreamChannel;
import org.xnio.channels.StreamSinkChannel;

class HttpClientConnectionImpl
extends HttpClientConnection
implements ConnectedChannel {
    private final OptionMap options;
    private final ConnectedStreamChannel underlyingChannel;
    private final PushBackStreamChannel readChannel;
    private final Pool<ByteBuffer> bufferPool;
    private final HttpRequestQueueStrategy queuingStrategy;
    private final ClientReadListener readListener = new ClientReadListener();
    private final ChannelListener.Setter<ConnectedChannel> closeSetter;
    private static final int UPGRADED = 0x20000000;
    private static final int CLOSE_REQ = 0x40000000;
    private static final int CLOSED = Integer.MIN_VALUE;
    private volatile int state;
    private static final AtomicIntegerFieldUpdater<HttpClientConnectionImpl> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(HttpClientConnectionImpl.class, "state");
    private volatile boolean pipelining;

    HttpClientConnectionImpl(ConnectedStreamChannel underlyingChannel, PushBackStreamChannel readChannel, OptionMap options, final HttpClientImpl client) {
        super(client);
        this.options = options;
        this.underlyingChannel = underlyingChannel;
        this.readChannel = readChannel;
        this.bufferPool = client.getBufferPool();
        this.queuingStrategy = HttpRequestQueueStrategy.create(this, options);
        this.closeSetter = ChannelListeners.getDelegatingSetter(underlyingChannel.getCloseSetter(), this);
        this.pipelining = this.queuingStrategy.supportsPipelining();
        this.getCloseSetter().set((ChannelListener<? extends ConnectedChannel>)new ChannelListener<ConnectedChannel>(){

            @Override
            public void handleEvent(ConnectedChannel channel) {
                IoUtils.safeClose((Closeable)HttpClientConnectionImpl.this);
                client.connectionClosed(HttpClientConnectionImpl.this);
            }
        });
    }

    ConnectedStreamChannel getChannel() {
        return this.underlyingChannel;
    }

    @Override
    Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.underlyingChannel.getPeerAddress();
    }

    @Override
    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return this.underlyingChannel.getPeerAddress(type);
    }

    @Override
    public ChannelListener.Setter<? extends ConnectedChannel> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.underlyingChannel.getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return this.underlyingChannel.getLocalAddress(type);
    }

    @Override
    public XnioWorker getWorker() {
        return this.underlyingChannel.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.underlyingChannel.getIoThread();
    }

    @Override
    public boolean isOpen() {
        return this.underlyingChannel.isOpen();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.underlyingChannel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.underlyingChannel.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.underlyingChannel.setOption(option, value);
    }

    @Override
    OptionMap getOptions() {
        return this.options;
    }

    @Override
    public HttpClientRequest createRequest(HttpString method, URI target) {
        return this.internalCreateRequest(method, target, this.pipelining);
    }

    @Override
    public void performUpgrade(final UpgradeHandshake handshake, OptionMap optionMap, final HttpClientCallback<ConnectedStreamChannel> callback) {
        int newState;
        int oldState;
        do {
            if (!Bits.allAreSet(oldState = this.state, -536870912)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldState, newState = oldState | 0x20000000));
        HttpClientRequest request = handshake.createRequest(this);
        request.writeRequest(new HttpClientCallback<HttpClientResponse>(){

            @Override
            public void completed(HttpClientResponse response) {
                if (response.getResponseCode() == 101) {
                    try {
                        handshake.validateResponse(HttpClientConnectionImpl.this, response);
                        AssembledConnectedStreamChannel channel = new AssembledConnectedStreamChannel(HttpClientConnectionImpl.this.readChannel, HttpClientConnectionImpl.this.underlyingChannel);
                        callback.completed(channel);
                    }
                    catch (IOException e) {
                        callback.failed(e);
                    }
                } else {
                    String result = response.getReasonPhrase();
                    callback.failed(new IOException(UndertowClientMessages.MESSAGES.failedToUpgradeChannel(response.getResponseCode(), result)));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(IOException e) {
                try {
                    callback.failed(e);
                }
                finally {
                    int oldState;
                    while (!Bits.allAreClear(oldState = HttpClientConnectionImpl.this.state, 0x20000000)) {
                        int newState = oldState & 0x20000000;
                        if (!stateUpdater.compareAndSet(HttpClientConnectionImpl.this, oldState, newState)) continue;
                    }
                }
            }
        });
    }

    @Override
    public IoFuture<ConnectedStreamChannel> performUpgrade(UpgradeHandshake request, OptionMap optionMap) {
        final ConcreteIoFuture<ConnectedStreamChannel> future = new ConcreteIoFuture<ConnectedStreamChannel>();
        this.performUpgrade(request, optionMap, new HttpClientCallback<ConnectedStreamChannel>(){

            @Override
            public void completed(ConnectedStreamChannel result) {
                future.setResult(result);
            }

            @Override
            public void failed(IOException e) {
                future.setException(e);
            }
        });
        return future;
    }

    protected HttpClientRequest internalCreateRequest(HttpString method, URI target, boolean pipelining) {
        if (Bits.allAreSet(this.state, 0x60000000)) {
            return null;
        }
        return new HttpClientRequestImpl(this, this.underlyingChannel, method, target, pipelining);
    }

    @Override
    public void close() throws IOException {
        int newState;
        int oldState;
        do {
            if (!Bits.allAreSet(oldState = this.state, Integer.MIN_VALUE)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldState, newState = oldState | Integer.MIN_VALUE | 0x40000000));
        this.underlyingChannel.close();
    }

    void enqueueRequest(PendingHttpRequest request) {
        int newState;
        int oldState;
        do {
            if (!Bits.anyAreSet(oldState = this.state, -1073741824)) continue;
            request.setFailed(new IOException(UndertowClientMessages.MESSAGES.connectionClosed()));
            return;
        } while (!stateUpdater.compareAndSet(this, oldState, newState = oldState + 1));
        UndertowLogger.CLIENT_LOGGER.tracef("adding new request %s %s", (Object)request, (Object)request.getRequest());
        this.queuingStrategy.addNewRequest(request);
    }

    void sendingCompleted(PendingHttpRequest request) {
        this.queuingStrategy.requestSent(request);
        UndertowLogger.CLIENT_LOGGER.tracef("request fully sent %s", (Object)request);
        int currentState = this.state;
        if (Bits.allAreSet(currentState, 0x40000000)) {
            try {
                this.underlyingChannel.shutdownWrites();
            }
            catch (IOException e) {
                UndertowLogger.CLIENT_LOGGER.debugf((Throwable)e, "failed to shutdown writes", new Object[0]);
            }
        }
    }

    void requestCompleted(PendingHttpRequest request) {
        int currentState = stateUpdater.getAndDecrement(this);
        this.queuingStrategy.requestCompleted(request);
        UndertowLogger.CLIENT_LOGGER.tracef("request completed %s", (Object)request);
        if (Bits.allAreSet(currentState, 0x40000000)) {
            try {
                this.close();
            }
            catch (IOException e) {
                UndertowLogger.CLIENT_LOGGER.debugf((Throwable)e, "failed to close channel", new Object[0]);
            }
        }
    }

    void requestConnectionClose() throws IOException {
        int newState;
        int oldState;
        do {
            if (!Bits.anyAreSet(oldState = this.state, -1073741824)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldState, newState = oldState | 0x40000000));
        UndertowLogger.CLIENT_LOGGER.tracef("request to close the connection", new Object[0]);
        if (newState == 0x40000000) {
            this.close();
        }
    }

    void doSendRequest(final PendingHttpRequest request, boolean fromCallback) {
        int currentState = this.state;
        if (Bits.anyAreSet(currentState, -1073741824)) {
            request.setCancelled();
            this.sendingCompleted(request);
            return;
        }
        UndertowLogger.CLIENT_LOGGER.tracef("start sending request %s", (Object)request);
        if (fromCallback) {
            this.underlyingChannel.getWriteSetter().set((ChannelListener<? extends ConnectedStreamChannel>)new ChannelListener<StreamSinkChannel>(){

                @Override
                public void handleEvent(StreamSinkChannel channel) {
                    request.startSendingRequest();
                }
            });
            this.underlyingChannel.resumeWrites();
        } else {
            request.startSendingRequest();
        }
    }

    void doReadResponse(PendingHttpRequest request) {
        assert (this.readListener.activeRequest == null);
        UndertowLogger.CLIENT_LOGGER.tracef("start reading response for %s", (Object)request);
        this.readListener.activeRequest = request;
        this.readChannel.getReadSetter().set(this.readListener);
        this.readChannel.resumeReads();
    }

    class ClientReadListener
    implements ChannelListener<PushBackStreamChannel> {
        volatile PendingHttpRequest activeRequest;

        ClientReadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(PushBackStreamChannel channel) {
            PendingHttpRequest builder = this.activeRequest;
            Pooled<ByteBuffer> pooled = HttpClientConnectionImpl.this.bufferPool.allocate();
            ByteBuffer buffer = (ByteBuffer)pooled.getResource();
            boolean free = true;
            try {
                ResponseParseState state = builder.getParseState();
                do {
                    int res;
                    buffer.clear();
                    try {
                        res = channel.read(buffer);
                    }
                    catch (IOException e) {
                        if (UndertowLogger.CLIENT_LOGGER.isDebugEnabled()) {
                            UndertowLogger.CLIENT_LOGGER.debugf((Throwable)e, "Connection closed with IOException", new Object[0]);
                        }
                        IoUtils.safeClose((Closeable)channel);
                        if (free) {
                            pooled.free();
                        }
                        return;
                    }
                    if (res == 0) {
                        if (!channel.isReadResumed()) {
                            channel.getReadSetter().set(this);
                            channel.resumeReads();
                        }
                        return;
                    }
                    if (res == -1) {
                        try {
                            channel.suspendReads();
                            channel.shutdownReads();
                            ConnectedStreamChannel requestChannel = HttpClientConnectionImpl.this.underlyingChannel;
                            requestChannel.shutdownWrites();
                            if (!requestChannel.flush()) {
                                requestChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                                requestChannel.resumeWrites();
                            }
                            builder.setFailed(new IOException(UndertowClientMessages.MESSAGES.connectionClosed()));
                        }
                        catch (IOException e) {
                            if (UndertowLogger.CLIENT_LOGGER.isDebugEnabled()) {
                                UndertowLogger.CLIENT_LOGGER.debugf((Throwable)e, "Connection closed with IOException when attempting to shut down reads", new Object[0]);
                            }
                            builder.setFailed(e);
                            IoUtils.safeClose((Closeable)channel);
                            if (free) {
                                pooled.free();
                            }
                            return;
                        }
                        return;
                    }
                    buffer.flip();
                    HttpResponseParser.INSTANCE.handle(buffer, state, builder);
                    if (!buffer.hasRemaining()) continue;
                    free = false;
                    channel.unget(pooled);
                } while (!state.isComplete());
                channel.getReadSetter().set(null);
                channel.suspendReads();
                this.activeRequest = null;
                builder.handleResponseComplete(HttpClientConnectionImpl.this, channel);
            }
            catch (Exception e) {
                UndertowLogger.CLIENT_LOGGER.exceptionProcessingRequest(e);
                IoUtils.safeClose((Closeable)HttpClientConnectionImpl.this.underlyingChannel);
            }
            finally {
                if (free) {
                    pooled.free();
                }
            }
        }
    }
}

