/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.cache;

import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.cache.CachedHttpRequest;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.cache.ResponseCache;
import io.undertow.server.handlers.cache.ResponseCachingStreamSinkConduit;
import io.undertow.util.ConduitFactory;
import io.undertow.util.Headers;
import org.xnio.conduits.StreamSinkConduit;

public class CacheHandler
implements HttpHandler {
    private final DirectBufferCache<CachedHttpRequest> cache;
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;

    public CacheHandler(DirectBufferCache<CachedHttpRequest> cache, HttpHandler next) {
        this.cache = cache;
        this.next = next;
    }

    public CacheHandler(DirectBufferCache<CachedHttpRequest> cache) {
        this.cache = cache;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        final ResponseCache responseCache = new ResponseCache(this.cache, exchange);
        exchange.putAttachment(ResponseCache.ATTACHMENT_KEY, responseCache);
        exchange.addResponseWrapper(new ConduitWrapper<StreamSinkConduit>(){

            @Override
            public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
                if (!responseCache.isResponseCachable()) {
                    return factory.create();
                }
                String lengthString = exchange.getResponseHeaders().getFirst(Headers.CONTENT_LENGTH);
                if (lengthString == null) {
                    return factory.create();
                }
                int length = Integer.parseInt(lengthString);
                CachedHttpRequest key = new CachedHttpRequest(exchange);
                DirectBufferCache.CacheEntry entry = CacheHandler.this.cache.add(key, length);
                if (entry == null || entry.buffers().length == 0 || !entry.claimEnable()) {
                    return factory.create();
                }
                if (!entry.reference()) {
                    entry.disable();
                    return factory.create();
                }
                return new ResponseCachingStreamSinkConduit(factory.create(), entry, length);
            }
        });
        HttpHandlers.executeHandler(this.next, exchange);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public CacheHandler setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
        return this;
    }
}

