/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.CopyOnWriteMap;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class PathHandler
implements HttpHandler {
    private volatile HttpHandler defaultHandler = ResponseCodeHandler.HANDLE_404;
    private final ConcurrentMap<String, HttpHandler> paths = new CopyOnWriteMap<String, HttpHandler>();
    private volatile int maxPathLength = 0;

    public PathHandler(HttpHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public PathHandler() {
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String path;
        int length = (path = exchange.getRelativePath()).length();
        int pos = length > this.maxPathLength ? this.maxPathLength : length;
        String part = path.substring(0, pos);
        HttpHandler next = (HttpHandler)this.paths.get(part);
        if (next != null) {
            exchange.setRelativePath(path.substring(pos));
            exchange.setResolvedPath(exchange.getResolvedPath() + part);
            next.handleRequest(exchange);
            return;
        }
        while (pos > 1) {
            if (path.charAt(--pos) != '/' || (next = (HttpHandler)this.paths.get(part = path.substring(0, pos))) == null) continue;
            exchange.setRelativePath(path.substring(pos));
            exchange.setResolvedPath(exchange.getResolvedPath() + part);
            next.handleRequest(exchange);
            return;
        }
        this.defaultHandler.handleRequest(exchange);
    }

    public synchronized PathHandler addPath(String path, HttpHandler handler) {
        int pathLength;
        HttpHandlers.handlerNotNull(handler);
        if (path.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        if (path.equals("/")) {
            this.defaultHandler = handler;
            return this;
        }
        if (path.charAt(0) != '/') {
            pathLength = path.length() + 1;
            this.paths.put("/" + path, handler);
        } else {
            pathLength = path.length();
            this.paths.put(path, handler);
        }
        if (pathLength > this.maxPathLength) {
            this.maxPathLength = path.length() + pathLength;
        }
        return this;
    }

    public synchronized PathHandler removePath(String path) {
        if (path == null || path.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        if (path.equals("/")) {
            this.defaultHandler = ResponseCodeHandler.HANDLE_404;
            return this;
        }
        if (path.charAt(0) != '/') {
            this.paths.remove("/" + path);
        } else {
            this.paths.remove(path);
        }
        int max = 0;
        for (Map.Entry entry : this.paths.entrySet()) {
            if (((String)entry.getKey()).length() <= max) continue;
            max = ((String)entry.getKey()).length();
        }
        this.maxPathLength = max;
        return this;
    }

    public synchronized PathHandler clearPaths() {
        this.paths.clear();
        this.defaultHandler = ResponseCodeHandler.HANDLE_404;
        return this;
    }

    public Map<String, HttpHandler> getPaths() {
        return Collections.unmodifiableMap(this.paths);
    }
}

