/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.predicate.Predicates;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.NotificationReceiverHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.security.impl.CachedAuthenticatedSessionMechanism;
import io.undertow.security.impl.ClientCertAuthenticationMechanism;
import io.undertow.security.impl.DigestAuthenticationMechanism;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.HttpContinueReadHandler;
import io.undertow.server.handlers.PredicateHandler;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.HttpMethodSecurityInfo;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.core.ContextClassLoaderSetupAction;
import io.undertow.servlet.core.DeploymentImpl;
import io.undertow.servlet.core.ErrorPages;
import io.undertow.servlet.core.Lifecycle;
import io.undertow.servlet.core.ManagedListener;
import io.undertow.servlet.core.SecurityActions;
import io.undertow.servlet.core.SessionListenerBridge;
import io.undertow.servlet.handlers.ServletDispatchingHandler;
import io.undertow.servlet.handlers.ServletInitialHandler;
import io.undertow.servlet.handlers.security.CachedAuthenticatedSessionHandler;
import io.undertow.servlet.handlers.security.SSLInformationAssociationHandler;
import io.undertow.servlet.handlers.security.SecurityPathMatches;
import io.undertow.servlet.handlers.security.ServletAuthenticationConstraintHandler;
import io.undertow.servlet.handlers.security.ServletConfidentialityConstraintHandler;
import io.undertow.servlet.handlers.security.ServletFormAuthenticationMechanism;
import io.undertow.servlet.handlers.security.ServletSecurityConstraintHandler;
import io.undertow.servlet.predicate.DispatcherTypePredicate;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.util.MimeMappings;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletException;

public class DeploymentManagerImpl
implements DeploymentManager {
    private final DeploymentInfo originalDeployment;
    private final ServletContainer servletContainer;
    private volatile DeploymentImpl deployment;
    private volatile DeploymentManager.State state = DeploymentManager.State.UNDEPLOYED;

    public DeploymentManagerImpl(DeploymentInfo deployment, ServletContainer servletContainer) {
        this.originalDeployment = deployment;
        this.servletContainer = servletContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy() {
        DeploymentImpl deployment;
        DeploymentInfo deploymentInfo = this.originalDeployment.clone();
        deploymentInfo.validate();
        this.deployment = deployment = new DeploymentImpl(deploymentInfo, this.servletContainer);
        ServletContextImpl servletContext = new ServletContextImpl(this.servletContainer, deployment);
        deployment.setServletContext(servletContext);
        this.handleExtensions(deploymentInfo, servletContext);
        deployment.setSessionManager(deploymentInfo.getSessionManagerFactory().createSessionManager(deployment));
        deployment.getSessionManager().setDefaultSessionTimeout(deploymentInfo.getDefaultSessionTimeout());
        ArrayList<ThreadSetupAction> setup = new ArrayList<ThreadSetupAction>();
        setup.add(new ContextClassLoaderSetupAction(deploymentInfo.getClassLoader()));
        setup.addAll(deploymentInfo.getThreadSetupActions());
        CompositeThreadSetupAction threadSetupAction = new CompositeThreadSetupAction(setup);
        deployment.setThreadSetupAction(threadSetupAction);
        ThreadSetupAction.Handle handle = threadSetupAction.setup(null);
        try {
            ApplicationListeners listeners = this.createListeners();
            deployment.setApplicationListeners(listeners);
            this.createServletsAndFilters(deployment, deploymentInfo);
            for (ServletContainerInitializerInfo sci : deploymentInfo.getServletContainerInitializers()) {
                InstanceHandle<? extends ServletContainerInitializer> instance = sci.getInstanceFactory().createInstance();
                try {
                    instance.getInstance().onStartup(sci.getHandlesTypes(), servletContext);
                }
                finally {
                    instance.release();
                }
            }
            deployment.getSessionManager().registerSessionListener(new SessionListenerBridge(threadSetupAction, listeners, servletContext));
            this.initializeErrorPages(deployment, deploymentInfo);
            this.initializeMimeMappings(deployment, deploymentInfo);
            this.initializeTempDir(servletContext, deploymentInfo);
            listeners.contextInitialized();
            HttpHandler wrappedHandlers = ServletDispatchingHandler.INSTANCE;
            wrappedHandlers = DeploymentManagerImpl.wrapHandlers(wrappedHandlers, deploymentInfo.getInnerHandlerChainWrappers());
            HttpHandler securityHandler = this.setupSecurityHandlers(wrappedHandlers);
            wrappedHandlers = new PredicateHandler(DispatcherTypePredicate.REQUEST, securityHandler, wrappedHandlers);
            HttpHandler outerHandlers = DeploymentManagerImpl.wrapHandlers(wrappedHandlers, deploymentInfo.getOuterHandlerChainWrappers());
            wrappedHandlers = new PredicateHandler(Predicates.or(DispatcherTypePredicate.REQUEST, DispatcherTypePredicate.ASYNC), outerHandlers, wrappedHandlers);
            ServletInitialHandler servletInitialHandler = new ServletInitialHandler(deployment.getServletPaths(), wrappedHandlers, deployment.getThreadSetupAction(), servletContext);
            HttpHandler initialHandler = DeploymentManagerImpl.wrapHandlers(servletInitialHandler, deployment.getDeploymentInfo().getInitialHandlerChainWrappers());
            initialHandler = new HttpContinueReadHandler(initialHandler);
            deployment.setInitialHandler(initialHandler);
            deployment.setServletHandler(servletInitialHandler);
            deployment.getServletPaths().invalidate();
            servletContext.initDone();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            handle.tearDown();
        }
        this.state = DeploymentManager.State.DEPLOYED;
    }

    private void createServletsAndFilters(DeploymentImpl deployment, DeploymentInfo deploymentInfo) {
        for (Map.Entry<String, ServletInfo> entry : deploymentInfo.getServlets().entrySet()) {
            deployment.getServlets().addServlet(entry.getValue());
        }
        for (Map.Entry<String, Cloneable> entry : deploymentInfo.getFilters().entrySet()) {
            deployment.getFilters().addFilter((FilterInfo)entry.getValue());
        }
    }

    private void handleExtensions(DeploymentInfo deploymentInfo, ServletContextImpl servletContext) {
        for (ServletExtension extension : ServiceLoader.load(ServletExtension.class, deploymentInfo.getClassLoader())) {
            extension.handleDeployment(deploymentInfo, servletContext);
        }
    }

    private HttpHandler setupSecurityHandlers(HttpHandler initialHandler) {
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        LoginConfig loginConfig = deploymentInfo.getLoginConfig();
        HttpHandler current = initialHandler;
        current = new SSLInformationAssociationHandler(current);
        SecurityPathMatches securityPathMatches = this.buildSecurityConstraints();
        current = new AuthenticationCallHandler(current);
        if (!securityPathMatches.isEmpty()) {
            current = new ServletAuthenticationConstraintHandler(current);
        }
        current = new ServletConfidentialityConstraintHandler(deploymentInfo.getConfidentialPortManager(), current);
        if (!securityPathMatches.isEmpty()) {
            current = new ServletSecurityConstraintHandler(securityPathMatches, current);
        }
        String mechName = null;
        if (loginConfig != null || !deploymentInfo.getAdditionalAuthenticationMechanisms().isEmpty()) {
            LinkedList<AuthenticationMechanism> authenticationMechanisms = new LinkedList<AuthenticationMechanism>();
            authenticationMechanisms.add(new CachedAuthenticatedSessionMechanism());
            authenticationMechanisms.addAll(deploymentInfo.getAdditionalAuthenticationMechanisms());
            if (loginConfig != null) {
                mechName = loginConfig.getAuthMethod();
                if (!deploymentInfo.isIgnoreStandardAuthenticationMechanism() && mechName != null) {
                    String[] mechanisms;
                    for (String mechanism : mechanisms = mechName.split(",")) {
                        if (mechanism.equalsIgnoreCase("BASIC")) {
                            authenticationMechanisms.add(new BasicAuthenticationMechanism(loginConfig.getRealmName(), "BASIC"));
                            continue;
                        }
                        if (mechanism.equalsIgnoreCase("BASIC-SILENT")) {
                            authenticationMechanisms.add(new BasicAuthenticationMechanism(loginConfig.getRealmName(), "BASIC-SILENT", true));
                            continue;
                        }
                        if (mechanism.equalsIgnoreCase("FORM")) {
                            authenticationMechanisms.add(new ServletFormAuthenticationMechanism("FORM", loginConfig.getLoginPage(), loginConfig.getErrorPage()));
                            continue;
                        }
                        if (mechanism.equalsIgnoreCase("CLIENT_CERT")) {
                            authenticationMechanisms.add(new ClientCertAuthenticationMechanism("CLIENT_CERT"));
                            continue;
                        }
                        if (mechanism.equalsIgnoreCase("DIGEST")) {
                            authenticationMechanisms.add(new DigestAuthenticationMechanism(loginConfig.getRealmName(), deploymentInfo.getContextPath(), "DIGEST"));
                            continue;
                        }
                        throw UndertowServletMessages.MESSAGES.unknownAuthenticationMechanism(mechanism);
                    }
                }
            }
            current = new AuthenticationMechanismsHandler(current, authenticationMechanisms);
        }
        current = new CachedAuthenticatedSessionHandler(current, this.deployment.getServletContext());
        List<NotificationReceiver> notificationReceivers = deploymentInfo.getNotificationReceivers();
        if (!notificationReceivers.isEmpty()) {
            current = new NotificationReceiverHandler(current, notificationReceivers);
        }
        current = new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, deploymentInfo.getIdentityManager(), mechName, current);
        return current;
    }

    private SecurityPathMatches buildSecurityConstraints() {
        SecurityPathMatches.Builder builder = SecurityPathMatches.builder(this.deployment.getDeploymentInfo());
        HashSet<String> urlPatterns = new HashSet<String>();
        for (SecurityConstraint constraint : this.deployment.getDeploymentInfo().getSecurityConstraints()) {
            builder.addSecurityConstraint(constraint);
            for (WebResourceCollection webResources : constraint.getWebResourceCollections()) {
                urlPatterns.addAll(webResources.getUrlPatterns());
            }
        }
        for (ServletInfo servlet : this.deployment.getDeploymentInfo().getServlets().values()) {
            ServletSecurityInfo securityInfo = servlet.getServletSecurityInfo();
            if (securityInfo == null) continue;
            HashSet<String> mappings = new HashSet<String>(servlet.getMappings());
            mappings.removeAll(urlPatterns);
            if (mappings.isEmpty()) continue;
            HashSet<String> methods = new HashSet<String>();
            for (HttpMethodSecurityInfo method : securityInfo.getHttpMethodSecurityInfo()) {
                methods.add(method.getMethod());
                if (method.getRolesAllowed().isEmpty() && method.getEmptyRoleSemantic() == SecurityInfo.EmptyRoleSemantic.PERMIT) continue;
                SecurityConstraint newConstraint = ((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().addRolesAllowed(method.getRolesAllowed())).setTransportGuaranteeType(method.getTransportGuaranteeType())).addWebResourceCollection(new WebResourceCollection().addUrlPatterns(mappings).addHttpMethod(method.getMethod()));
                builder.addSecurityConstraint(newConstraint);
            }
            if (securityInfo.getRolesAllowed().isEmpty() && securityInfo.getEmptyRoleSemantic() == SecurityInfo.EmptyRoleSemantic.PERMIT && !methods.isEmpty()) continue;
            SecurityConstraint newConstraint = ((SecurityConstraint)((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().setEmptyRoleSemantic(securityInfo.getEmptyRoleSemantic())).addRolesAllowed(securityInfo.getRolesAllowed())).setTransportGuaranteeType(securityInfo.getTransportGuaranteeType())).addWebResourceCollection(new WebResourceCollection().addUrlPatterns(mappings).addHttpMethodOmissions(methods));
            builder.addSecurityConstraint(newConstraint);
        }
        return builder.build();
    }

    private void initializeTempDir(ServletContextImpl servletContext, DeploymentInfo deploymentInfo) {
        if (deploymentInfo.getTempDir() != null) {
            servletContext.setAttribute("javax.servlet.context.tempdir", deploymentInfo.getTempDir());
        } else {
            servletContext.setAttribute("javax.servlet.context.tempdir", new File(SecurityActions.getSystemProperty("java.io.tmpdir")));
        }
    }

    private void initializeMimeMappings(DeploymentImpl deployment, DeploymentInfo deploymentInfo) {
        HashMap<String, String> mappings = new HashMap<String, String>(MimeMappings.DEFAULT_MIME_MAPPINGS);
        for (MimeMapping mapping : deploymentInfo.getMimeMappings()) {
            mappings.put(mapping.getExtension(), mapping.getMimeType());
        }
        deployment.setMimeExtensionMappings(mappings);
    }

    private void initializeErrorPages(DeploymentImpl deployment, DeploymentInfo deploymentInfo) {
        HashMap<Integer, String> codes = new HashMap<Integer, String>();
        HashMap<Class<? extends Throwable>, String> exceptions = new HashMap<Class<? extends Throwable>, String>();
        String defaultErrorPage = null;
        for (ErrorPage page : deploymentInfo.getErrorPages()) {
            if (page.getExceptionType() != null) {
                exceptions.put(page.getExceptionType(), page.getLocation());
                continue;
            }
            if (page.getErrorCode() != null) {
                codes.put(page.getErrorCode(), page.getLocation());
                continue;
            }
            if (defaultErrorPage != null) {
                throw UndertowServletMessages.MESSAGES.moreThanOneDefaultErrorPage(defaultErrorPage, page.getLocation());
            }
            defaultErrorPage = page.getLocation();
        }
        deployment.setErrorPages(new ErrorPages(codes, exceptions, defaultErrorPage));
    }

    private ApplicationListeners createListeners() {
        ArrayList<ManagedListener> managedListeners = new ArrayList<ManagedListener>();
        for (ListenerInfo listener : this.deployment.getDeploymentInfo().getListeners()) {
            managedListeners.add(new ManagedListener(listener, false));
        }
        return new ApplicationListeners(managedListeners, this.deployment.getServletContext());
    }

    private static HttpHandler wrapHandlers(HttpHandler wrapee, List<HandlerWrapper> wrappers) {
        HttpHandler current = wrapee;
        for (HandlerWrapper wrapper : wrappers) {
            current = wrapper.wrap(current);
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpHandler start() throws ServletException {
        ThreadSetupAction.Handle handle = this.deployment.getThreadSetupAction().setup(null);
        try {
            this.deployment.getSessionManager().start();
            for (Lifecycle object : this.deployment.getLifecycleObjects()) {
                object.start();
            }
            HttpHandler root = this.deployment.getHandler();
            this.state = DeploymentManager.State.STARTED;
            HttpHandler httpHandler = root;
            return httpHandler;
        }
        finally {
            handle.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws ServletException {
        ThreadSetupAction.Handle handle = this.deployment.getThreadSetupAction().setup(null);
        try {
            for (Lifecycle object : this.deployment.getLifecycleObjects()) {
                object.stop();
            }
            this.deployment.getSessionManager().stop();
        }
        finally {
            handle.tearDown();
        }
        this.state = DeploymentManager.State.DEPLOYED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy() {
        ThreadSetupAction.Handle handle = this.deployment.getThreadSetupAction().setup(null);
        try {
            this.deployment.getApplicationListeners().contextDestroyed();
            this.deployment.getApplicationListeners().stop();
            this.deployment = null;
        }
        finally {
            handle.tearDown();
        }
        this.state = DeploymentManager.State.UNDEPLOYED;
    }

    @Override
    public DeploymentManager.State getState() {
        return this.state;
    }

    @Override
    public Deployment getDeployment() {
        return this.deployment;
    }
}

