/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.UndertowClient;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyClientProvider;
import io.undertow.util.AttachmentKey;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.Channel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class SimpleProxyClientProvider
implements ProxyClientProvider {
    private final URI uri;
    private final AttachmentKey<ProxyClient> clientAttachmentKey = AttachmentKey.create(ProxyClient.class);
    private final UndertowClient client;

    public SimpleProxyClientProvider(URI uri) {
        this.uri = uri;
        this.client = UndertowClient.getInstance();
    }

    @Override
    public void createProxyClient(HttpServerExchange exchange, ProxyCallback<ProxyClient> callback, long timeout, TimeUnit timeUnit) {
        ProxyClient existing = exchange.getConnection().getAttachment(this.clientAttachmentKey);
        if (existing != null) {
            if (existing.isOpen()) {
                callback.completed(exchange, existing);
                return;
            }
            exchange.getConnection().removeAttachment(this.clientAttachmentKey);
        }
        this.client.connect((ClientCallback<ClientConnection>)new ConnectNotifier(callback, exchange), this.uri, exchange.getIoThread(), exchange.getConnection().getBufferPool(), OptionMap.EMPTY);
    }

    private static final class SimpleProxyClient
    implements ProxyClient {
        private final ClientConnection connection;

        private SimpleProxyClient(ClientConnection connection) {
            this.connection = connection;
        }

        @Override
        public void getConnection(HttpServerExchange exchange, ProxyCallback<ClientConnection> callback, long timeout, TimeUnit timeUnit) {
            callback.completed(exchange, this.connection);
        }

        @Override
        public boolean isOpen() {
            return this.connection.isOpen();
        }
    }

    private final class ConnectNotifier
    implements ClientCallback<ClientConnection> {
        private final ProxyCallback<ProxyClient> callback;
        private final HttpServerExchange exchange;

        private ConnectNotifier(ProxyCallback<ProxyClient> callback, HttpServerExchange exchange) {
            this.callback = callback;
            this.exchange = exchange;
        }

        @Override
        public void completed(final ClientConnection connection) {
            final ServerConnection serverConnection = this.exchange.getConnection();
            SimpleProxyClient simpleProxyClient = new SimpleProxyClient(connection);
            serverConnection.putAttachment(SimpleProxyClientProvider.this.clientAttachmentKey, simpleProxyClient);
            serverConnection.addCloseListener(new ServerConnection.CloseListener(){

                @Override
                public void closed(ServerConnection serverConnection) {
                    IoUtils.safeClose((Closeable)connection);
                }
            });
            connection.getCloseSetter().set((ChannelListener<? extends ClientConnection>)new ChannelListener<Channel>(){

                @Override
                public void handleEvent(Channel channel) {
                    serverConnection.removeAttachment(SimpleProxyClientProvider.this.clientAttachmentKey);
                }
            });
            this.callback.completed(this.exchange, simpleProxyClient);
        }

        @Override
        public void failed(IOException e) {
            this.callback.failed(this.exchange);
        }
    }
}

