/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;

public class ThreadNameAttribute
implements ExchangeAttribute {
    public static final String THREAD_NAME_SHORT = "%I";
    public static final String THREAD_NAME = "%{THREAD_NAME}";
    public static final ExchangeAttribute INSTANCE = new ThreadNameAttribute();

    private ThreadNameAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        return Thread.currentThread().getName();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Thread name", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Thread name";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(ThreadNameAttribute.THREAD_NAME) || token.equals(ThreadNameAttribute.THREAD_NAME_SHORT)) {
                return INSTANCE;
            }
            return null;
        }
    }
}

