/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketLogger;
import io.undertow.websockets.core.WebSocketMessages;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public abstract class StreamSourceFrameChannel
implements StreamSourceChannel {
    private final WebSocketChannel.StreamSourceChannelControl streamSourceChannelControl;
    protected final WebSocketFrameType type;
    protected final StreamSourceChannel channel;
    protected final WebSocketChannel wsChannel;
    private final ChannelListener.SimpleSetter<? extends StreamSourceFrameChannel> readSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<? extends StreamSourceFrameChannel> closeSetter = new ChannelListener.SimpleSetter();
    private final boolean finalFragment;
    private final int rsv;
    private final long payloadSize;
    private volatile boolean readsResumed;
    private volatile boolean complete;
    private volatile boolean closed;

    protected StreamSourceFrameChannel(WebSocketChannel.StreamSourceChannelControl streamSourceChannelControl, StreamSourceChannel channel, WebSocketChannel wsChannel, WebSocketFrameType type, long payloadSize) {
        this(streamSourceChannelControl, channel, wsChannel, type, payloadSize, 0, true);
    }

    protected StreamSourceFrameChannel(WebSocketChannel.StreamSourceChannelControl streamSourceChannelControl, StreamSourceChannel channel, WebSocketChannel wsChannel, WebSocketFrameType type, long payloadSize, int rsv, boolean finalFragment) {
        this.streamSourceChannelControl = streamSourceChannelControl;
        this.channel = channel;
        this.wsChannel = wsChannel;
        this.type = type;
        this.finalFragment = finalFragment;
        this.rsv = rsv;
        this.payloadSize = payloadSize;
    }

    public long getPayloadSize() {
        return this.payloadSize;
    }

    protected abstract boolean isComplete();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (this.complete) {
            return -1L;
        }
        try {
            long l = this.read0(dsts, offset, length);
            return l;
        }
        finally {
            if (this.isComplete()) {
                this.complete();
            }
        }
    }

    protected abstract long read0(ByteBuffer[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long read(ByteBuffer[] dsts) throws IOException {
        if (this.complete) {
            return -1L;
        }
        try {
            long l = this.read0(dsts);
            return l;
        }
        finally {
            if (this.isComplete()) {
                this.complete();
            }
        }
    }

    protected abstract long read0(ByteBuffer[] var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int read(ByteBuffer dst) throws IOException {
        if (this.complete) {
            return -1;
        }
        try {
            int i;
            int n = i = this.read0(dst);
            return n;
        }
        finally {
            if (this.isComplete()) {
                this.complete();
            }
        }
    }

    protected abstract int read0(ByteBuffer var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long transferTo(long position, long count, FileChannel target) throws IOException {
        if (this.complete) {
            return -1L;
        }
        try {
            long l = this.transferTo0(position, count, target);
            return l;
        }
        finally {
            if (this.isComplete()) {
                this.complete();
            }
        }
    }

    protected abstract long transferTo0(long var1, long var3, FileChannel var5) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        if (this.complete) {
            throughBuffer.clear();
            return -1L;
        }
        try {
            long l = this.transferTo0(count, throughBuffer, target);
            return l;
        }
        finally {
            if (this.isComplete()) {
                this.complete();
            }
        }
    }

    protected abstract long transferTo0(long var1, ByteBuffer var3, StreamSinkChannel var4) throws IOException;

    protected void complete() throws IOException {
        this.complete = true;
        this.streamSourceChannelControl.readFrameDone(this);
    }

    public WebSocketFrameType getType() {
        return this.type;
    }

    public boolean isFinalFragment() {
        return this.finalFragment;
    }

    public int getRsv() {
        return this.rsv;
    }

    public ChannelListener.SimpleSetter<? extends StreamSourceChannel> getReadSetter() {
        return this.readSetter;
    }

    @Override
    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.channel.getIoThread();
    }

    @Override
    public void close() throws IOException {
        if (!this.isComplete() && this.wsChannel.isOpen()) {
            this.wsChannel.markBroken();
            throw WebSocketMessages.MESSAGES.closedBeforeAllBytesWereRead();
        }
        this.closed = true;
        this.queueListener(this.closeSetter.get());
    }

    protected final void queueListener(final ChannelListener<StreamSourceFrameChannel> listener) {
        this.getIoThread().execute(new Runnable(){

            @Override
            public void run() {
                WebSocketLogger.REQUEST_LOGGER.debugf("Invoking directly queued read listener", new Object[0]);
                ChannelListeners.invokeChannelListener(StreamSourceFrameChannel.this, listener);
                if (!StreamSourceFrameChannel.this.complete) {
                    StreamSourceFrameChannel.this.channel.resumeReads();
                }
            }
        });
    }

    public void discard() throws IOException {
        if (!this.complete) {
            ChannelListener<StreamSourceChannel> drainListener = ChannelListeners.drainListener(Long.MAX_VALUE, new ChannelListener<StreamSourceChannel>(){

                @Override
                public void handleEvent(StreamSourceChannel channel) {
                    IoUtils.safeClose((Closeable)StreamSourceFrameChannel.this);
                }
            }, new ChannelExceptionHandler<StreamSourceChannel>(){

                @Override
                public void handleException(StreamSourceChannel channel, IOException exception) {
                    StreamSourceFrameChannel.this.wsChannel.markBroken();
                    IoUtils.safeClose(channel, StreamSourceFrameChannel.this.wsChannel);
                }
            });
            ((ChannelListener.SimpleSetter)this.getReadSetter()).set(drainListener);
            this.resumeReads();
        } else {
            this.close();
        }
    }

    @Override
    public void suspendReads() {
        this.readsResumed = false;
        if (!this.complete) {
            this.channel.suspendReads();
        }
    }

    @Override
    public void resumeReads() {
        this.readsResumed = true;
        if (this.complete) {
            this.queueListener(this.readSetter.get());
        } else {
            this.channel.resumeReads();
        }
    }

    @Override
    public boolean isReadResumed() {
        return this.readsResumed;
    }

    @Override
    public void wakeupReads() {
        this.readsResumed = true;
        this.queueListener(this.readSetter.get());
    }

    @Override
    public void shutdownReads() throws IOException {
        this.channel.shutdownReads();
    }

    @Override
    public void awaitReadable() throws IOException {
        this.channel.awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        this.channel.awaitReadable(time, timeUnit);
    }

    @Override
    public XnioExecutor getReadThread() {
        return this.channel.getReadThread();
    }

    @Override
    public boolean isOpen() {
        return !this.closed && this.channel.isOpen();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.channel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.channel.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IOException {
        return this.channel.setOption(option, value);
    }

    @Override
    public ChannelListener.Setter<? extends StreamSourceChannel> getCloseSetter() {
        return this.closeSetter;
    }
}

