/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.impl;

import io.undertow.websockets.core.WebSocketChannel;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import org.xnio.Pooled;
import org.xnio.channels.BlockingWritableByteChannel;
import org.xnio.channels.StreamSinkChannel;

final class TextWriter
extends Writer {
    private final StreamSinkChannel sink;
    private final BlockingWritableByteChannel ch;
    private final WebSocketChannel channel;

    public TextWriter(WebSocketChannel channel, StreamSinkChannel sink) {
        this.sink = sink;
        this.channel = channel;
        this.ch = new BlockingWritableByteChannel(sink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Pooled<ByteBuffer> pooled = this.channel.getBufferPool().allocate();
        try {
            ByteBuffer buffer = pooled.getResource();
            while (off < len) {
                buffer.putChar(cbuf[off]);
                ++off;
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                this.ch.write(buffer);
            }
        }
        finally {
            pooled.free();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
        this.sink.shutdownWrites();
        this.ch.flush();
        this.ch.close();
    }
}

