/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.Pooled;

public class BufferedBinaryMessage {
    private final List<Pooled<ByteBuffer>> data = new ArrayList<Pooled<ByteBuffer>>(1);
    private Pooled<ByteBuffer> current;
    private boolean closed = false;
    private final long maxMessageSize;
    long currentSize;

    public BufferedBinaryMessage(long maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public BufferedBinaryMessage() {
        this(-1L);
    }

    public void readBlocking(StreamSourceFrameChannel channel) throws IOException {
        if (this.closed) {
            throw WebSocketMessages.MESSAGES.dataHasBeenReleased();
        }
        if (this.current == null) {
            this.current = channel.getWebSocketChannel().getBufferPool().allocate();
        }
        int res;
        while ((res = channel.read(this.current.getResource())) != -1) {
            if (res == 0) {
                channel.awaitReadable();
            }
            this.checkMaxSize(channel, res);
            this.dealWithFullBuffer(channel);
        }
        return;
    }

    private void dealWithFullBuffer(StreamSourceFrameChannel channel) {
        if (!this.current.getResource().hasRemaining()) {
            this.current.getResource().flip();
            this.data.add(this.current);
            this.current = channel.getWebSocketChannel().getBufferPool().allocate();
        }
    }

    public void read(StreamSourceFrameChannel channel, final WebSocketCallback<BufferedBinaryMessage> callback) {
        if (this.closed) {
            throw WebSocketMessages.MESSAGES.dataHasBeenReleased();
        }
        if (this.current == null) {
            this.current = channel.getWebSocketChannel().getBufferPool().allocate();
        }
        try {
            while (true) {
                int res;
                if ((res = channel.read(this.current.getResource())) == -1) {
                    callback.complete(channel.getWebSocketChannel(), this);
                    return;
                }
                if (res == 0) {
                    ((ChannelListener.SimpleSetter)channel.getReadSetter()).set(new ChannelListener<StreamSourceFrameChannel>(){

                        @Override
                        public void handleEvent(StreamSourceFrameChannel channel) {
                            try {
                                while (true) {
                                    int res;
                                    if ((res = channel.read((ByteBuffer)BufferedBinaryMessage.this.current.getResource())) == -1) {
                                        channel.suspendReads();
                                        callback.complete(channel.getWebSocketChannel(), BufferedBinaryMessage.this);
                                        return;
                                    }
                                    if (res == 0) {
                                        return;
                                    }
                                    BufferedBinaryMessage.this.checkMaxSize(channel, res);
                                    BufferedBinaryMessage.this.dealWithFullBuffer(channel);
                                }
                            }
                            catch (IOException e) {
                                channel.suspendReads();
                                callback.onError(channel.getWebSocketChannel(), BufferedBinaryMessage.this, e);
                                return;
                            }
                        }
                    });
                    channel.resumeReads();
                    return;
                }
                this.checkMaxSize(channel, res);
                this.dealWithFullBuffer(channel);
            }
        }
        catch (IOException e) {
            callback.onError(channel.getWebSocketChannel(), this, e);
            return;
        }
    }

    private void checkMaxSize(StreamSourceFrameChannel channel, int res) throws IOException {
        this.currentSize += (long)res;
        if (this.maxMessageSize > 0L && this.currentSize > this.maxMessageSize) {
            WebSockets.sendClose(new CloseMessage(1009, WebSocketMessages.MESSAGES.messageToBig(this.maxMessageSize)).toByteBuffer(), channel.getWebSocketChannel(), null);
            throw new IOException(WebSocketMessages.MESSAGES.messageToBig(this.maxMessageSize));
        }
    }

    public ByteBuffer[] getData() {
        if (this.closed) {
            throw WebSocketMessages.MESSAGES.dataHasBeenReleased();
        }
        if (this.current == null) {
            return new ByteBuffer[0];
        }
        if (this.data.isEmpty()) {
            return new ByteBuffer[]{this.getCurrentFlipped()};
        }
        ByteBuffer[] ret = new ByteBuffer[this.data.size() + 1];
        for (int i = 0; i < this.data.size(); ++i) {
            ret[i] = this.data.get(i).getResource().duplicate();
        }
        ret[this.data.size()] = this.getCurrentFlipped();
        return ret;
    }

    public byte[] toByteArray() {
        Buffer[] payload = this.getData();
        int size = (int)Buffers.remaining(payload);
        byte[] buffer = new byte[size];
        int i = 0;
        for (Buffer buf : payload) {
            while (buf.hasRemaining()) {
                buffer[i++] = ((ByteBuffer)buf).get();
            }
        }
        return buffer;
    }

    private ByteBuffer getCurrentFlipped() {
        ByteBuffer copy = this.current.getResource().duplicate();
        copy.flip();
        return copy;
    }

    public void release() {
        if (this.closed) {
            return;
        }
        if (this.current != null) {
            this.current.free();
        }
        for (Pooled<ByteBuffer> pooled : this.data) {
            pooled.free();
        }
    }
}

