/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.UndertowLogger;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpUpgradeHandshake;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.StreamConnection;

public final class ChannelUpgradeHandler
implements HttpHandler {
    private final CopyOnWriteMap<String, List<Holder>> handlers = new CopyOnWriteMap();
    private volatile HttpHandler nonUpgradeHandler = ResponseCodeHandler.HANDLE_404;

    public synchronized void addProtocol(String productString, ChannelListener<? super StreamConnection> openListener, HttpUpgradeHandshake handshake) {
        if (productString == null) {
            throw new IllegalArgumentException("productString is null");
        }
        if (openListener == null) {
            throw new IllegalArgumentException("openListener is null");
        }
        List<Holder> list = this.handlers.get(productString);
        if (list == null) {
            list = new CopyOnWriteArrayList<Holder>();
            this.handlers.put(productString, list);
        }
        list.add(new Holder(openListener, handshake));
    }

    public void addProtocol(String productString, ChannelListener<? super StreamConnection> openListener) {
        this.addProtocol(productString, openListener, null);
    }

    public synchronized void removeProtocol(String productString) {
        this.handlers.remove(productString);
    }

    public synchronized void removeProtocol(String productString, ChannelListener<? super StreamConnection> openListener) {
        List<Holder> holders = this.handlers.get(productString);
        if (holders == null) {
            return;
        }
        Iterator<Holder> it = holders.iterator();
        while (it.hasNext()) {
            Holder holder = it.next();
            if (holder.listener != openListener) continue;
            it.remove();
            break;
        }
        if (holders.isEmpty()) {
            this.handlers.remove(productString);
        }
    }

    public HttpHandler getNonUpgradeHandler() {
        return this.nonUpgradeHandler;
    }

    public ChannelUpgradeHandler setNonUpgradeHandler(HttpHandler nonUpgradeHandler) {
        Handlers.handlerNotNull(nonUpgradeHandler);
        this.nonUpgradeHandler = nonUpgradeHandler;
        return this;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HeaderValues upgradeStrings = exchange.getRequestHeaders().get(Headers.UPGRADE);
        if (upgradeStrings != null && exchange.getRequestMethod().equals(Methods.GET)) {
            for (String string : upgradeStrings) {
                List<Holder> holders = this.handlers.get(string);
                if (holders == null) continue;
                for (Holder holder : holders) {
                    final ChannelListener<? super StreamConnection> listener = holder.listener;
                    if (holder.handshake != null && !holder.handshake.handleUpgrade(exchange)) continue;
                    exchange.upgradeChannel(string, new ExchangeCompletionListener(){

                        @Override
                        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                            try {
                                ChannelListeners.invokeChannelListener(exchange.getConnection().upgradeChannel(), listener);
                            }
                            catch (Exception e) {
                                UndertowLogger.REQUEST_LOGGER.cannotUpgradeConnection(e);
                            }
                        }
                    });
                    exchange.endExchange();
                    return;
                }
            }
        }
        this.nonUpgradeHandler.handleRequest(exchange);
    }

    private static final class Holder {
        final ChannelListener<? super StreamConnection> listener;
        final HttpUpgradeHandshake handshake;

        private Holder(ChannelListener<? super StreamConnection> listener, HttpUpgradeHandshake handshake) {
            this.listener = listener;
            this.handshake = handshake;
        }
    }
}

