/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class ProxyPeerAddressHandler
implements HttpHandler {
    private final HttpHandler next;

    public ProxyPeerAddressHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String forwardedFor = exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_FOR);
        if (forwardedFor != null) {
            int index = forwardedFor.indexOf(44);
            String value = index == -1 ? forwardedFor : forwardedFor.substring(0, index - 1);
            InetAddress address = InetAddress.getByName(value);
            exchange.setSourceAddress(new InetSocketAddress(address, 0));
        }
        this.next.handleRequest(exchange);
    }
}

