/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.UndertowMessages;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.UndertowClient;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyConnection;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;

class Host {
    private final LoadBalancingProxyClient loadBalancingProxyClient;
    private final URI uri;
    private final String jvmRoute;
    private final UndertowClient client;
    private volatile boolean problem;
    private volatile boolean closed;
    private final ConcurrentMap<XnioIoThread, HostThreadData> hostThreadData = new ConcurrentHashMap<XnioIoThread, HostThreadData>();

    public Host(LoadBalancingProxyClient loadBalancingProxyClient, URI uri, String jvmRoute, UndertowClient client) {
        this.loadBalancingProxyClient = loadBalancingProxyClient;
        this.uri = uri;
        this.jvmRoute = jvmRoute;
        this.client = client;
    }

    URI getUri() {
        return this.uri;
    }

    void close() {
        this.closed = true;
    }

    void returnConnection(ClientConnection connection) {
        HostThreadData hostData = this.getData();
        if (this.closed) {
            IoUtils.safeClose((Closeable)connection);
            ClientConnection con = hostData.availbleConnections.poll();
            while (con != null) {
                IoUtils.safeClose((Closeable)con);
                con = hostData.availbleConnections.poll();
            }
            this.redistributeQueued(hostData);
            return;
        }
        if (connection.isOpen() && !connection.isUpgraded()) {
            CallbackHolder callback = hostData.awaitingConnections.poll();
            while (callback != null && callback.isCancelled()) {
                callback = hostData.awaitingConnections.poll();
            }
            if (callback != null) {
                if (callback.getTimeoutKey() != null) {
                    callback.getTimeoutKey().remove();
                }
                this.connectionReady(connection, callback.getCallback(), callback.getExchange());
            } else {
                hostData.availbleConnections.add(connection);
            }
        } else if (connection.isOpen() && connection.isUpgraded()) {
            connection.getCloseSetter().set(null);
            this.handleClosedConnection(hostData, connection);
        }
    }

    private void handleClosedConnection(HostThreadData hostData, ClientConnection connection) {
        int connections = --hostData.connections;
        hostData.availbleConnections.remove(connection);
        if (connections < this.loadBalancingProxyClient.getConnectionsPerThread()) {
            CallbackHolder task = hostData.awaitingConnections.poll();
            while (task != null && task.isCancelled()) {
                task = hostData.awaitingConnections.poll();
            }
            if (task != null) {
                this.openConnection(task.exchange, task.callback, hostData);
            }
        }
    }

    private void openConnection(final HttpServerExchange exchange, final ProxyCallback<ProxyConnection> callback, final HostThreadData data) {
        ++data.connections;
        this.client.connect(new ClientCallback<ClientConnection>(){

            @Override
            public void completed(ClientConnection result) {
                Host.this.problem = false;
                result.getCloseSetter().set((ChannelListener<? extends ClientConnection>)new ChannelListener<ClientConnection>(){

                    @Override
                    public void handleEvent(ClientConnection channel) {
                        Host.this.handleClosedConnection(data, channel);
                    }
                });
                Host.this.connectionReady(result, callback, exchange);
            }

            @Override
            public void failed(IOException e) {
                --data.connections;
                Host.this.problem = true;
                Host.this.redistributeQueued(Host.this.getData());
                Host.this.scheduleFailedHostRetry(exchange);
                callback.failed(exchange);
            }
        }, this.getUri(), exchange.getIoThread(), exchange.getConnection().getBufferPool(), OptionMap.EMPTY);
    }

    private void redistributeQueued(HostThreadData hostData) {
        CallbackHolder callback = hostData.awaitingConnections.poll();
        while (callback != null) {
            if (callback.getTimeoutKey() != null) {
                callback.getTimeoutKey().remove();
            }
            if (!callback.isCancelled()) {
                long time = System.currentTimeMillis();
                if (callback.getExpireTime() > 0L && callback.getExpireTime() < time) {
                    callback.getCallback().failed(callback.getExchange());
                } else {
                    this.loadBalancingProxyClient.getConnection(callback.getExchange(), callback.getCallback(), callback.getExpireTime() > 0L ? time - callback.getExpireTime() : -1L, TimeUnit.MILLISECONDS);
                    callback.getCallback().failed(callback.getExchange());
                }
            }
            callback = hostData.awaitingConnections.poll();
        }
    }

    private void connectionReady(final ClientConnection result, ProxyCallback<ProxyConnection> callback, HttpServerExchange exchange) {
        exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

            @Override
            public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                Host.this.returnConnection(result);
                nextListener.proceed();
            }
        });
        callback.completed(exchange, new ProxyConnection(result, this.uri.getPath() == null ? "/" : this.uri.getPath()));
    }

    AvailabilityType availible() {
        if (this.closed) {
            return AvailabilityType.CLOSED;
        }
        if (this.problem) {
            return AvailabilityType.PROBLEM;
        }
        HostThreadData data = this.getData();
        if (data.connections < this.loadBalancingProxyClient.getConnectionsPerThread()) {
            return AvailabilityType.AVAILABLE;
        }
        if (!data.availbleConnections.isEmpty()) {
            return AvailabilityType.AVAILABLE;
        }
        return AvailabilityType.FULL;
    }

    String getJvmRoute() {
        return this.jvmRoute;
    }

    private void scheduleFailedHostRetry(final HttpServerExchange exchange) {
        exchange.getIoThread().executeAfter(new Runnable(){

            @Override
            public void run() {
                if (Host.this.closed) {
                    return;
                }
                Host.this.client.connect(new ClientCallback<ClientConnection>(){

                    @Override
                    public void completed(ClientConnection result) {
                        Host.this.problem = false;
                        Host.this.returnConnection(result);
                    }

                    @Override
                    public void failed(IOException e) {
                        Host.this.scheduleFailedHostRetry(exchange);
                    }
                }, Host.this.getUri(), exchange.getIoThread(), exchange.getConnection().getBufferPool(), OptionMap.EMPTY);
            }
        }, this.loadBalancingProxyClient.getProblemServerRetry(), TimeUnit.SECONDS);
    }

    private HostThreadData getData() {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof XnioIoThread)) {
            throw UndertowMessages.MESSAGES.canOnlyBeCalledByIoThread();
        }
        XnioIoThread ioThread = (XnioIoThread)thread;
        HostThreadData data = (HostThreadData)this.hostThreadData.get(ioThread);
        if (data != null) {
            return data;
        }
        data = new HostThreadData();
        HostThreadData existing = this.hostThreadData.putIfAbsent(ioThread, data);
        if (existing != null) {
            return existing;
        }
        return data;
    }

    public void connect(HttpServerExchange exchange, ProxyCallback<ProxyConnection> callback, long timeout, TimeUnit timeUnit) {
        HostThreadData data = this.getData();
        ClientConnection conn = data.availbleConnections.poll();
        while (conn != null && !conn.isOpen()) {
            conn = data.availbleConnections.poll();
        }
        if (conn != null) {
            this.connectionReady(conn, callback, exchange);
        } else if (data.connections < this.loadBalancingProxyClient.getConnectionsPerThread()) {
            this.openConnection(exchange, callback, data);
        } else {
            CallbackHolder holder;
            if (timeout > 0L) {
                long time = System.currentTimeMillis();
                holder = new CallbackHolder(callback, exchange, time + timeUnit.toMillis(timeout));
                holder.setTimeoutKey(exchange.getIoThread().executeAfter(holder, timeout, timeUnit));
            } else {
                holder = new CallbackHolder(callback, exchange, -1L);
            }
            data.awaitingConnections.add(holder);
        }
    }

    static enum AvailabilityType {
        AVAILABLE,
        FULL,
        PROBLEM,
        CLOSED;

    }

    private static final class CallbackHolder
    implements Runnable {
        final ProxyCallback<ProxyConnection> callback;
        final HttpServerExchange exchange;
        final long expireTime;
        XnioExecutor.Key timeoutKey;
        boolean cancelled = false;

        private CallbackHolder(ProxyCallback<ProxyConnection> callback, HttpServerExchange exchange, long expireTime) {
            this.callback = callback;
            this.exchange = exchange;
            this.expireTime = expireTime;
        }

        private ProxyCallback<ProxyConnection> getCallback() {
            return this.callback;
        }

        private HttpServerExchange getExchange() {
            return this.exchange;
        }

        private long getExpireTime() {
            return this.expireTime;
        }

        private XnioExecutor.Key getTimeoutKey() {
            return this.timeoutKey;
        }

        private boolean isCancelled() {
            return this.cancelled;
        }

        private void setTimeoutKey(XnioExecutor.Key timeoutKey) {
            this.timeoutKey = timeoutKey;
        }

        @Override
        public void run() {
            this.cancelled = true;
            this.callback.failed(this.exchange);
        }
    }

    private static final class HostThreadData {
        int connections = 0;
        final Deque<ClientConnection> availbleConnections = new ArrayDeque<ClientConnection>();
        final Deque<CallbackHolder> awaitingConnections = new ArrayDeque<CallbackHolder>();

        private HostThreadData() {
        }
    }
}

