/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.client.UndertowClient;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.proxy.Host;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.util.CopyOnWriteMap;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class LoadBalancingProxyClient
implements ProxyClient {
    private volatile int problemServerRetry = 10;
    private final Set<String> sessionCookieNames = new CopyOnWriteArraySet<String>();
    private volatile int connectionsPerThread = 10;
    private volatile Host[] hosts = new Host[0];
    private final AtomicInteger currentHost = new AtomicInteger(0);
    private final UndertowClient client;
    private final Map<String, Host> routes = new CopyOnWriteMap<String, Host>();

    public LoadBalancingProxyClient() {
        this(UndertowClient.getInstance());
    }

    public LoadBalancingProxyClient(UndertowClient client) {
        this.client = client;
        this.sessionCookieNames.add("JSESSIONID");
    }

    public LoadBalancingProxyClient addSessionCookieName(String sessionCookieName) {
        this.sessionCookieNames.add(sessionCookieName);
        return this;
    }

    public LoadBalancingProxyClient removeSessionCookieName(String sessionCookieName) {
        this.sessionCookieNames.remove(sessionCookieName);
        return this;
    }

    public LoadBalancingProxyClient setProblemServerRetry(int problemServerRetry) {
        this.problemServerRetry = problemServerRetry;
        return this;
    }

    public int getProblemServerRetry() {
        return this.problemServerRetry;
    }

    public int getConnectionsPerThread() {
        return this.connectionsPerThread;
    }

    public LoadBalancingProxyClient setConnectionsPerThread(int connectionsPerThread) {
        this.connectionsPerThread = connectionsPerThread;
        return this;
    }

    public synchronized LoadBalancingProxyClient addHost(URI host) {
        return this.addHost(host, null);
    }

    public synchronized LoadBalancingProxyClient addHost(URI host, String jvmRoute) {
        Host h = new Host(this, host, jvmRoute, this.client);
        Host[] existing = this.hosts;
        Host[] newHosts = new Host[existing.length + 1];
        System.arraycopy(existing, 0, newHosts, 0, existing.length);
        newHosts[existing.length] = h;
        this.hosts = newHosts;
        if (jvmRoute != null) {
            this.routes.put(jvmRoute, h);
        }
        return this;
    }

    public synchronized LoadBalancingProxyClient removeHost(URI uri) {
        int found = -1;
        Host[] existing = this.hosts;
        Host removedHost = null;
        for (int i = 0; i < existing.length; ++i) {
            if (!existing[i].getUri().equals(uri)) continue;
            found = i;
            removedHost = existing[i];
            break;
        }
        if (found == -1) {
            return this;
        }
        Host[] newHosts = new Host[existing.length - 1];
        System.arraycopy(existing, 0, newHosts, 0, found);
        System.arraycopy(existing, found + 1, newHosts, found, existing.length - found - 1);
        this.hosts = newHosts;
        removedHost.close();
        if (removedHost.getJvmRoute() != null) {
            this.routes.remove(removedHost.getJvmRoute());
        }
        return this;
    }

    @Override
    public void getConnection(HttpServerExchange exchange, ProxyCallback<ProxyConnection> callback, long timeout, TimeUnit timeUnit) {
        Host host = this.selectHost(exchange);
        if (host == null) {
            callback.failed(exchange);
        } else {
            host.connect(exchange, callback, timeout, timeUnit);
        }
    }

    protected Host selectHost(HttpServerExchange exchange) {
        int host;
        Host[] hosts = this.hosts;
        if (hosts.length == 0) {
            return null;
        }
        Host sticky = this.findStickyHost(exchange);
        if (sticky != null) {
            return sticky;
        }
        int startHost = host = this.currentHost.incrementAndGet() % hosts.length;
        Host full = null;
        Host problem = null;
        do {
            Host selected;
            Host.AvailabilityType availble;
            if ((availble = (selected = hosts[host]).availible()) == Host.AvailabilityType.AVAILABLE) {
                return selected;
            }
            if (availble == Host.AvailabilityType.FULL && full == null) {
                full = selected;
                continue;
            }
            if (availble != Host.AvailabilityType.PROBLEM || problem != null) continue;
            problem = selected;
        } while ((host = (host + 1) % hosts.length) != startHost);
        if (full != null) {
            return full;
        }
        if (problem != null) {
            return problem;
        }
        return null;
    }

    protected Host findStickyHost(HttpServerExchange exchange) {
        Map<String, Cookie> cookies = exchange.getRequestCookies();
        for (String cookieName : this.sessionCookieNames) {
            int index;
            Cookie sk = cookies.get(cookieName);
            if (sk == null || (index = sk.getValue().indexOf(46)) == -1) continue;
            String route = sk.getValue().substring(index + 1);
            index = route.indexOf(46);
            if (index != -1) {
                route = route.substring(0, index);
            }
            return this.routes.get(route);
        }
        return null;
    }
}

