/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.io;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.xnio.Buffers;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.Channels;
import org.xnio.channels.EmptyStreamSourceChannel;
import org.xnio.channels.StreamSourceChannel;

public class UndertowInputStream
extends InputStream {
    private final Pool<ByteBuffer> bufferPool;
    private final StreamSourceChannel channel;
    private boolean closed;
    private Pooled<ByteBuffer> pooled;

    public UndertowInputStream(HttpServerExchange exchange) {
        this.bufferPool = exchange.getConnection().getBufferPool();
        this.channel = exchange.isRequestChannelAvailable() ? exchange.getRequestChannel() : new EmptyStreamSourceChannel(exchange.getIoThread());
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b);
        if (read == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        this.readIntoBuffer();
        if (this.closed) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        ByteBuffer buffer = this.pooled.getResource();
        int copied = Buffers.copy(ByteBuffer.wrap(b, off, len), buffer);
        if (!buffer.hasRemaining()) {
            this.pooled.free();
            this.pooled = null;
        }
        return copied;
    }

    private void readIntoBuffer() throws IOException {
        if (this.pooled == null && !this.closed) {
            this.pooled = this.bufferPool.allocate();
            int res = Channels.readBlocking(this.channel, this.pooled.getResource());
            this.pooled.getResource().flip();
            if (res == -1) {
                this.closed = true;
                this.pooled.free();
                this.pooled = null;
            }
        }
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        this.readIntoBuffer();
        if (this.closed) {
            return -1;
        }
        return this.pooled.getResource().remaining();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        while (!this.closed) {
            this.readIntoBuffer();
            if (this.pooled == null) continue;
            this.pooled.free();
            this.pooled = null;
        }
    }
}

