/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.impl.SingleSignOnEntry;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.util.ConduitFactory;
import io.undertow.util.Sessions;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.xnio.conduits.StreamSinkConduit;

public abstract class AbstractSingleSignOnAuthenticationMechanism
implements AuthenticationMechanism {
    private static final SecureRandomSessionIdGenerator SECURE_RANDOM_SESSION_ID_GENERATOR = new SecureRandomSessionIdGenerator();
    private static final String SSO_SESSION_ATTRIBUTE = AbstractSingleSignOnAuthenticationMechanism.class.getName() + ".SSOID";
    private final Set<SessionManager> seenSessionManagers = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private String cookieName = "JSESSIONIDSSO";
    private boolean httpOnly;
    private boolean secure;
    private String domain;
    private final SessionInvalidationListener listener = new SessionInvalidationListener();
    private final ResponseListener responseListener = new ResponseListener();

    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        Cookie cookie = exchange.getRequestCookies().get(this.cookieName);
        if (cookie != null) {
            SingleSignOnEntry entry = this.findSsoEntry(cookie.getValue());
            if (entry != null) {
                this.registerSessionIfRequired(exchange, entry);
                securityContext.authenticationComplete(entry.getAccount(), entry.getMechanismName(), false);
                return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
            }
            this.clearSsoCookie(exchange);
        }
        exchange.addResponseWrapper(this.responseListener);
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    protected abstract SingleSignOnEntry findSsoEntry(String var1);

    protected abstract void storeSsoEntry(String var1, SingleSignOnEntry var2);

    protected abstract void removeSsoEntry(String var1);

    private void registerSessionIfRequired(HttpServerExchange exchange, SingleSignOnEntry entry) {
        Session session = this.getSession(exchange);
        if (!entry.getSessions().containsKey(session.getId())) {
            entry.getSessions().put(session.getId(), session);
            if (!this.seenSessionManagers.contains(session.getSessionManager())) {
                session.getSessionManager().registerSessionListener(this.listener);
            }
        }
    }

    private void clearSsoCookie(HttpServerExchange exchange) {
        exchange.getResponseCookies().put(this.cookieName, new CookieImpl(this.cookieName).setMaxAge(0).setHttpOnly(this.httpOnly).setSecure(this.secure).setDomain(this.domain));
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return new AuthenticationMechanism.ChallengeResult(false);
    }

    protected Session getSession(HttpServerExchange exchange) {
        return Sessions.getOrCreateSession(exchange);
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public AbstractSingleSignOnAuthenticationMechanism setCookieName(String cookieName) {
        this.cookieName = cookieName;
        return this;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public AbstractSingleSignOnAuthenticationMechanism setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public AbstractSingleSignOnAuthenticationMechanism setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public AbstractSingleSignOnAuthenticationMechanism setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    private final class SessionInvalidationListener
    implements SessionListener {
        private SessionInvalidationListener() {
        }

        @Override
        public void sessionCreated(Session session, HttpServerExchange exchange) {
        }

        @Override
        public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
            SingleSignOnEntry entry;
            Object sso = session.getAttribute(SSO_SESSION_ATTRIBUTE);
            if (sso != null && (entry = AbstractSingleSignOnAuthenticationMechanism.this.findSsoEntry((String)sso)) != null) {
                entry.getSessions().remove(session.getId());
                if (reason == SessionListener.SessionDestroyedReason.INVALIDATED) {
                    for (Map.Entry<String, Session> s : entry.getSessions().entrySet()) {
                        s.getValue().invalidate(null);
                    }
                    AbstractSingleSignOnAuthenticationMechanism.this.removeSsoEntry((String)sso);
                }
            }
        }

        @Override
        public void attributeAdded(Session session, String name, Object value) {
        }

        @Override
        public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
        }

        @Override
        public void attributeRemoved(Session session, String name, Object oldValue) {
        }

        @Override
        public void sessionIdChanged(Session session, String oldSessionId) {
        }
    }

    private final class ResponseListener
    implements ConduitWrapper<StreamSinkConduit> {
        private ResponseListener() {
        }

        @Override
        public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
            SecurityContext sc = exchange.getSecurityContext();
            Account account = sc.getAuthenticatedAccount();
            if (account != null) {
                String ssoId = SECURE_RANDOM_SESSION_ID_GENERATOR.createSessionId();
                SingleSignOnEntry entry = new SingleSignOnEntry(account, sc.getMechanismName());
                AbstractSingleSignOnAuthenticationMechanism.this.registerSessionIfRequired(exchange, entry);
                AbstractSingleSignOnAuthenticationMechanism.this.storeSsoEntry(ssoId, entry);
                exchange.getResponseCookies().put(AbstractSingleSignOnAuthenticationMechanism.this.cookieName, new CookieImpl(AbstractSingleSignOnAuthenticationMechanism.this.cookieName, ssoId).setHttpOnly(AbstractSingleSignOnAuthenticationMechanism.this.httpOnly).setSecure(AbstractSingleSignOnAuthenticationMechanism.this.secure).setDomain(AbstractSingleSignOnAuthenticationMechanism.this.domain));
            }
            return factory.create();
        }
    }
}

