/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import java.util.ArrayList;

public class CanonicalPathUtils {
    static final int START = -1;
    static final int NORMAL = 0;
    static final int FIRST_SLASH = 1;
    static final int ONE_DOT = 2;
    static final int TWO_DOT = 3;

    public static String canonicalize(String path) {
        int state = -1;
        block4: for (int i = path.length() - 1; i >= 0; --i) {
            char c = path.charAt(i);
            switch (c) {
                case '/': {
                    if (state == 2) {
                        return CanonicalPathUtils.realCanonicalize(path, i + 2, 1);
                    }
                    if (state == 3) {
                        return CanonicalPathUtils.realCanonicalize(path, i + 3, 1);
                    }
                    state = 1;
                    continue block4;
                }
                case '.': {
                    if (state == 1 || state == -1) {
                        state = 2;
                        continue block4;
                    }
                    if (state == 2) {
                        state = 3;
                        continue block4;
                    }
                    state = 0;
                    continue block4;
                }
                default: {
                    state = 0;
                }
            }
        }
        return path;
    }

    private static String realCanonicalize(String path, int lastDot, int initialState) {
        int state = initialState;
        int eatCount = 0;
        int tokenEnd = path.length();
        ArrayList<String> parts = new ArrayList<String>();
        block6: for (int i = lastDot - 1; i >= 0; --i) {
            char c = path.charAt(i);
            switch (state) {
                case 0: {
                    if (c != '/') continue block6;
                    state = 1;
                    if (eatCount <= 0) continue block6;
                    --eatCount;
                    tokenEnd = i;
                    continue block6;
                }
                case 1: {
                    if (c == '.') {
                        state = 2;
                        continue block6;
                    }
                    if (c == '/') {
                        state = 1;
                        continue block6;
                    }
                    state = 0;
                    continue block6;
                }
                case 2: {
                    if (c == '.') {
                        state = 3;
                        continue block6;
                    }
                    if (c == '/') {
                        if (i + 2 != tokenEnd) {
                            parts.add(path.substring(i + 2, tokenEnd));
                        }
                        tokenEnd = i;
                        state = 1;
                        continue block6;
                    }
                    state = 0;
                    continue block6;
                }
                case 3: {
                    if (c == '/') {
                        if (i + 3 != tokenEnd) {
                            parts.add(path.substring(i + 3, tokenEnd));
                        }
                        tokenEnd = i;
                        ++eatCount;
                        state = 1;
                        continue block6;
                    }
                    state = 0;
                }
            }
        }
        if (eatCount > 0) {
            return "/";
        }
        StringBuilder result = new StringBuilder();
        if (tokenEnd != 0) {
            result.append(path.substring(0, tokenEnd));
        }
        for (int i = parts.size() - 1; i >= 0; --i) {
            result.append((String)parts.get(i));
        }
        return result.toString();
    }

    private CanonicalPathUtils() {
    }
}

