/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.core.Lifecycle;
import io.undertow.servlet.spec.FilterConfigImpl;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ManagedFilter
implements Lifecycle {
    private final FilterInfo filterInfo;
    private final ServletContext servletContext;
    private volatile boolean started = false;
    private volatile Filter filter;
    private volatile InstanceHandle<? extends Filter> handle;

    public ManagedFilter(FilterInfo filterInfo, ServletContext servletContext) {
        this.filterInfo = filterInfo;
        this.servletContext = servletContext;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.started) {
            this.start();
        }
        this.getFilter().doFilter(request, response, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Filter getFilter() throws ServletException {
        if (this.filter == null) {
            ManagedFilter managedFilter = this;
            synchronized (managedFilter) {
                if (this.filter == null) {
                    try {
                        this.handle = this.filterInfo.getInstanceFactory().createInstance();
                    }
                    catch (Exception e) {
                        throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(this.filterInfo.getName(), e);
                    }
                    Filter filter = this.handle.getInstance();
                    filter.init(new FilterConfigImpl(this.filterInfo, this.servletContext));
                    this.filter = filter;
                }
            }
        }
        return this.filter;
    }

    @Override
    public synchronized void start() throws ServletException {
        if (!this.started) {
            this.started = true;
        }
    }

    @Override
    public synchronized void stop() {
        this.started = false;
        if (this.handle != null) {
            this.filter.destroy();
            this.handle.release();
        }
        this.filter = null;
        this.handle = null;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }
}

