/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.handlers;

import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.SecurityContextImpl;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;

public class SecurityInitialHandler
implements HttpHandler {
    private final AuthenticationMode authenticationMode;
    private final IdentityManager identityManager;
    private final HttpHandler next;
    private final String programaticMechName;

    public SecurityInitialHandler(AuthenticationMode authenticationMode, IdentityManager identityManager, String programaticMechName, HttpHandler next) {
        this.authenticationMode = authenticationMode;
        this.identityManager = identityManager;
        this.programaticMechName = programaticMechName;
        this.next = next;
    }

    public SecurityInitialHandler(AuthenticationMode authenticationMode, IdentityManager identityManager, HttpHandler next) {
        this(authenticationMode, identityManager, null, next);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityContextImpl newContext = new SecurityContextImpl(exchange, this.authenticationMode, this.identityManager);
        if (this.programaticMechName != null) {
            newContext.setProgramaticMechName(this.programaticMechName);
        }
        exchange.setSecurityContext(newContext);
        this.next.handleRequest(exchange);
    }
}

