/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSockets;
import java.io.Closeable;
import java.io.IOException;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;

public abstract class AbstractReceiveListener
implements ChannelListener<WebSocketChannel> {
    private BufferedBinaryMessage binaryMessage;
    private BufferedBinaryMessage control;
    private BufferedTextMessage textMessage;
    private WebSocketFrameType lastFragmeneted;

    @Override
    public void handleEvent(WebSocketChannel channel) {
        try {
            StreamSourceFrameChannel result = channel.receive();
            if (result == null) {
                return;
            }
            if (result.getType() == WebSocketFrameType.BINARY) {
                if (!result.isFinalFragment()) {
                    this.lastFragmeneted = WebSocketFrameType.BINARY;
                }
                this.onBinary(channel, result);
            } else if (result.getType() == WebSocketFrameType.TEXT) {
                if (!result.isFinalFragment()) {
                    this.lastFragmeneted = WebSocketFrameType.TEXT;
                }
                this.onText(channel, result);
            } else if (result.getType() == WebSocketFrameType.PONG) {
                this.onPong(channel, result);
            } else if (result.getType() == WebSocketFrameType.CONTINUATION) {
                if (this.textMessage != null || this.binaryMessage != null) {
                    this.bufferFullMessage(result);
                } else {
                    this.onContinuation(channel, result);
                    if (result.isFinalFragment()) {
                        this.lastFragmeneted = null;
                    }
                }
            } else if (result.getType() == WebSocketFrameType.PING) {
                this.onPing(channel, result);
            } else if (result.getType() == WebSocketFrameType.CLOSE) {
                this.onClose(channel, result);
            }
        }
        catch (IOException e) {
            this.onError(channel, e);
        }
    }

    protected void onPing(WebSocketChannel webSocketChannel, StreamSourceFrameChannel channel) throws IOException {
        this.bufferFullMessage(channel);
    }

    protected void onClose(WebSocketChannel webSocketChannel, StreamSourceFrameChannel channel) throws IOException {
        this.bufferFullMessage(channel);
    }

    protected void onPong(WebSocketChannel webSocketChannel, StreamSourceFrameChannel messageChannel) throws IOException {
        this.bufferFullMessage(messageChannel);
    }

    protected void onText(WebSocketChannel webSocketChannel, StreamSourceFrameChannel messageChannel) throws IOException {
        this.bufferFullMessage(messageChannel);
    }

    protected void onBinary(WebSocketChannel webSocketChannel, StreamSourceFrameChannel messageChannel) throws IOException {
        this.bufferFullMessage(messageChannel);
    }

    protected void onContinuation(WebSocketChannel webSocketChannel, StreamSourceFrameChannel messageChannel) throws IOException {
        if (this.lastFragmeneted == WebSocketFrameType.TEXT) {
            this.onText(webSocketChannel, messageChannel);
        } else {
            this.onBinary(webSocketChannel, messageChannel);
        }
    }

    protected void onError(WebSocketChannel channel, Throwable error) {
        IoUtils.safeClose((Closeable)channel);
    }

    protected final void bufferFullMessage(StreamSourceFrameChannel messageChannel) {
        boolean finalFrame = messageChannel.isFinalFragment();
        if (messageChannel.getType() == WebSocketFrameType.CONTINUATION) {
            if (this.textMessage != null) {
                this.readBufferedText(messageChannel, finalFrame);
            } else if (this.binaryMessage != null) {
                this.readBufferedBinary(messageChannel, finalFrame, false);
            }
        } else if (messageChannel.getType() == WebSocketFrameType.TEXT) {
            this.textMessage = new BufferedTextMessage(this.getMaxTextBufferSize());
            this.readBufferedText(messageChannel, finalFrame);
        } else if (messageChannel.getType() == WebSocketFrameType.BINARY) {
            this.binaryMessage = new BufferedBinaryMessage(this.getMaxBinaryBufferSize());
            this.readBufferedBinary(messageChannel, finalFrame, false);
        } else if (messageChannel.getType() == WebSocketFrameType.PONG) {
            this.control = new BufferedBinaryMessage(-1L);
            this.readBufferedBinary(messageChannel, finalFrame, true);
        } else if (messageChannel.getType() == WebSocketFrameType.PING) {
            this.control = new BufferedBinaryMessage(-1L);
            this.readBufferedBinary(messageChannel, finalFrame, true);
        } else if (messageChannel.getType() == WebSocketFrameType.CLOSE) {
            this.control = new BufferedBinaryMessage(-1L);
            this.readBufferedBinary(messageChannel, finalFrame, true);
        }
    }

    protected long getMaxBinaryBufferSize() {
        return -1L;
    }

    protected long getMaxTextBufferSize() {
        return -1L;
    }

    private void readBufferedBinary(final StreamSourceFrameChannel messageChannel, final boolean finalFrame, final boolean controlFrame) {
        final BufferedBinaryMessage buffer = controlFrame ? this.control : this.binaryMessage;
        buffer.read(messageChannel, new WebSocketCallback<BufferedBinaryMessage>(){

            @Override
            public void complete(WebSocketChannel channel, BufferedBinaryMessage context) {
                if (finalFrame) {
                    try {
                        WebSocketFrameType type = messageChannel.getType();
                        if (!controlFrame) {
                            AbstractReceiveListener.this.onFullBinaryMessage(channel, buffer);
                        } else if (type == WebSocketFrameType.PONG) {
                            AbstractReceiveListener.this.onFullPongMessage(channel, buffer);
                        } else if (type == WebSocketFrameType.PING) {
                            AbstractReceiveListener.this.onFullPingMessage(channel, buffer);
                        } else if (type == WebSocketFrameType.CLOSE) {
                            AbstractReceiveListener.this.onFullCloseMessage(channel, buffer);
                        }
                        if (controlFrame) {
                            AbstractReceiveListener.this.control = null;
                        } else {
                            AbstractReceiveListener.this.binaryMessage = null;
                        }
                    }
                    catch (IOException e) {
                        AbstractReceiveListener.this.onError(channel, e);
                    }
                }
            }

            @Override
            public void onError(WebSocketChannel channel, BufferedBinaryMessage context, Throwable throwable) {
                context.release();
                AbstractReceiveListener.this.onError(channel, throwable);
                if (controlFrame) {
                    AbstractReceiveListener.this.control = null;
                } else {
                    AbstractReceiveListener.this.binaryMessage = null;
                }
            }
        });
    }

    private void readBufferedText(StreamSourceFrameChannel messageChannel, final boolean finalFrame) {
        this.textMessage.read(messageChannel, new WebSocketCallback<BufferedTextMessage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete(WebSocketChannel channel, BufferedTextMessage context) {
                if (finalFrame) {
                    try {
                        AbstractReceiveListener.this.onFullTextMessage(channel, AbstractReceiveListener.this.textMessage);
                    }
                    catch (IOException e) {
                        AbstractReceiveListener.this.onError(channel, e);
                    }
                    finally {
                        AbstractReceiveListener.this.textMessage = null;
                    }
                }
            }

            @Override
            public void onError(WebSocketChannel channel, BufferedTextMessage context, Throwable throwable) {
                AbstractReceiveListener.this.onError(channel, throwable);
                AbstractReceiveListener.this.textMessage = null;
            }
        });
    }

    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
    }

    protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
    }

    protected void onFullPingMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
        WebSockets.sendPong(message.getData(), channel, null);
    }

    protected void onFullPongMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
    }

    protected void onFullCloseMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
        WebSockets.sendClose(message.getData(), channel, null);
    }
}

