/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.UndertowClient;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyClientProvider;
import io.undertow.util.AttachmentKey;
import io.undertow.util.SameThreadExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.Channel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class SimpleProxyClientProvider
implements ProxyClientProvider {
    private final URI uri;
    private final AttachmentKey<ProxyClient> clientAttachmentKey = AttachmentKey.create(ProxyClient.class);
    private final UndertowClient client;

    public SimpleProxyClientProvider(URI uri) {
        this.uri = uri;
        this.client = UndertowClient.getInstance();
    }

    @Override
    public void createProxyClient(final HttpServerExchange exchange, final HttpHandler nextHandler, long timeout, TimeUnit timeUnit) {
        ProxyClient existing = exchange.getConnection().getAttachment(this.clientAttachmentKey);
        if (existing != null) {
            if (existing.isOpen()) {
                exchange.putAttachment(CLIENT, existing);
                exchange.dispatch(SameThreadExecutor.INSTANCE, nextHandler);
                return;
            }
            exchange.getConnection().removeAttachment(this.clientAttachmentKey);
        }
        exchange.dispatch(SameThreadExecutor.INSTANCE, new Runnable(){

            @Override
            public void run() {
                SimpleProxyClientProvider.this.client.connect((ClientCallback<ClientConnection>)new ConnectNotifier(nextHandler, exchange), SimpleProxyClientProvider.this.uri, exchange.getIoThread(), exchange.getConnection().getBufferPool(), OptionMap.EMPTY);
            }
        });
    }

    private static final class SimpleProxyClient
    implements ProxyClient {
        private final ClientConnection connection;

        private SimpleProxyClient(ClientConnection connection) {
            this.connection = connection;
        }

        @Override
        public void getConnection(HttpServerExchange exchange, HttpHandler nextHandler, long timeout, TimeUnit timeUnit) {
            exchange.putAttachment(CONNECTION, this.connection);
            exchange.dispatch(SameThreadExecutor.INSTANCE, nextHandler);
        }

        @Override
        public boolean isOpen() {
            return this.connection.isOpen();
        }
    }

    private final class ConnectNotifier
    implements ClientCallback<ClientConnection> {
        private final HttpHandler next;
        private final HttpServerExchange exchange;

        private ConnectNotifier(HttpHandler next, HttpServerExchange exchange) {
            this.next = next;
            this.exchange = exchange;
        }

        @Override
        public void completed(final ClientConnection connection) {
            final ServerConnection serverConnection = this.exchange.getConnection();
            SimpleProxyClient simpleProxyClient = new SimpleProxyClient(connection);
            serverConnection.putAttachment(SimpleProxyClientProvider.this.clientAttachmentKey, simpleProxyClient);
            this.exchange.putAttachment(ProxyClientProvider.CLIENT, simpleProxyClient);
            serverConnection.addCloseListener(new ServerConnection.CloseListener(){

                @Override
                public void closed(ServerConnection serverConnection) {
                    IoUtils.safeClose((Closeable)connection);
                }
            });
            connection.getCloseSetter().set((ChannelListener<? extends ClientConnection>)new ChannelListener<Channel>(){

                @Override
                public void handleEvent(Channel channel) {
                    serverConnection.removeAttachment(SimpleProxyClientProvider.this.clientAttachmentKey);
                }
            });
            this.exchange.dispatch(SameThreadExecutor.INSTANCE, this.next);
        }

        @Override
        public void failed(IOException e) {
            this.exchange.putAttachment(ProxyClientProvider.THROWABLE, e);
            this.exchange.dispatch(SameThreadExecutor.INSTANCE, this.next);
        }
    }
}

