/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.client;

import io.undertow.websockets.client.WebSocketClientHandshake;
import io.undertow.websockets.client.WebSocketClientNegotiation;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketVersion;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.xnio.ChannelListener;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.http.HttpUpgrade;

public class WebSocketClient {
    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, Pool<ByteBuffer> bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version) {
        return WebSocketClient.connect(worker, bufferPool, optionMap, uri, version, null);
    }

    public static IoFuture<WebSocketChannel> connect(XnioWorker worker, final Pool<ByteBuffer> bufferPool, OptionMap optionMap, URI uri, WebSocketVersion version, WebSocketClientNegotiation clientNegotiation) {
        URI newUri;
        final FutureResult ioFuture = new FutureResult();
        try {
            newUri = new URI(uri.getScheme().equals("wss") ? "https" : "http", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath().isEmpty() ? "/" : uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        final WebSocketClientHandshake handshake = WebSocketClientHandshake.create(version, newUri, clientNegotiation);
        Map<String, String> headers = handshake.createHeaders();
        if (clientNegotiation != null) {
            clientNegotiation.beforeRequest(headers);
        }
        IoFuture<StreamConnection> result = HttpUpgrade.performUpgrade(worker, null, newUri, headers, (ChannelListener<? super StreamConnection>)new ChannelListener<StreamConnection>(){

            @Override
            public void handleEvent(StreamConnection channel) {
                WebSocketChannel result = handshake.createChannel(channel, newUri.toString(), bufferPool);
                ioFuture.setResult(result);
            }
        }, null, optionMap, handshake.handshakeChecker(newUri, headers));
        result.addNotifier(new IoFuture.Notifier<StreamConnection, Object>(){

            @Override
            public void notify(IoFuture<? extends StreamConnection> res, Object attachment) {
                if (res.getStatus() == IoFuture.Status.FAILED) {
                    ioFuture.setException(res.getException());
                }
            }
        }, null);
        return ioFuture.getIoFuture();
    }

    private WebSocketClient() {
    }
}

