/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.spdy;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.spdy.SpdyClientExchange;
import io.undertow.spdy.SpdyChannel;
import io.undertow.spdy.SpdyPingStreamSourceChannel;
import io.undertow.spdy.SpdyStreamSourceChannel;
import io.undertow.spdy.SpdySynReplyStreamSourceChannel;
import io.undertow.spdy.SpdySynStreamStreamSinkChannel;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;

public class SpdyClientConnection
implements ClientConnection {
    static final HttpString METHOD = new HttpString(":method");
    static final HttpString PATH = new HttpString(":path");
    static final HttpString SCHEME = new HttpString(":scheme");
    static final HttpString VERSION = new HttpString(":version");
    static final HttpString HOST = new HttpString(":host");
    static final HttpString STATUS = new HttpString(":status");
    private final SpdyChannel spdyChannel;
    private final ChannelListener.SimpleSetter<ClientConnection> closeSetter = new ChannelListener.SimpleSetter();
    private final Map<Integer, SpdyClientExchange> currentExchanges = new ConcurrentHashMap<Integer, SpdyClientExchange>();

    public SpdyClientConnection(SpdyChannel spdyChannel) {
        this.spdyChannel = spdyChannel;
        spdyChannel.getReceiveSetter().set(new SpdyRecieveListener());
        spdyChannel.resumeReceives();
    }

    @Override
    public void sendRequest(ClientRequest request, ClientCallback<ClientExchange> clientCallback) {
        request.getRequestHeaders().add(PATH, request.getPath());
        request.getRequestHeaders().add(SCHEME, "https");
        request.getRequestHeaders().add(VERSION, request.getProtocol().toString());
        request.getRequestHeaders().add(METHOD, request.getMethod().toString());
        request.getRequestHeaders().add(HOST, request.getRequestHeaders().getFirst(Headers.HOST));
        SpdySynStreamStreamSinkChannel sinkChannel = this.spdyChannel.createStream(request.getRequestHeaders());
        SpdyClientExchange exchange = new SpdyClientExchange(this, sinkChannel, request);
        this.currentExchanges.put(sinkChannel.getStreamId(), exchange);
        boolean hasContent = true;
        String fixedLengthString = request.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
        String transferEncodingString = request.getRequestHeaders().getLast(Headers.TRANSFER_ENCODING);
        if (fixedLengthString != null) {
            try {
                long length = Long.parseLong(fixedLengthString);
                hasContent = length != 0L;
            }
            catch (NumberFormatException e) {
                this.handleError(new IOException(e));
                return;
            }
        } else if (transferEncodingString == null) {
            hasContent = false;
        }
        if (clientCallback != null) {
            clientCallback.completed(exchange);
        }
        if (!hasContent) {
            try {
                sinkChannel.shutdownWrites();
                if (!sinkChannel.flush()) {
                    sinkChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, new ChannelExceptionHandler<StreamSinkChannel>(){

                        @Override
                        public void handleException(StreamSinkChannel channel, IOException exception) {
                            SpdyClientConnection.this.handleError(exception);
                        }
                    }));
                }
            }
            catch (IOException e) {
                this.handleError(e);
            }
        } else if (!sinkChannel.isWriteResumed()) {
            try {
                if (!sinkChannel.flush()) {
                    sinkChannel.getWriteSetter().set(new ChannelListener<StreamSinkChannel>(){

                        @Override
                        public void handleEvent(StreamSinkChannel channel) {
                            try {
                                if (channel.flush()) {
                                    channel.suspendWrites();
                                }
                            }
                            catch (IOException e) {
                                SpdyClientConnection.this.handleError(e);
                            }
                        }
                    });
                    sinkChannel.resumeWrites();
                }
            }
            catch (IOException e) {
                this.handleError(e);
            }
        }
    }

    private void handleError(IOException e) {
        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
        IoUtils.safeClose((Closeable)this);
        for (Map.Entry<Integer, SpdyClientExchange> entry : this.currentExchanges.entrySet()) {
            try {
                entry.getValue().failed(e);
            }
            catch (Exception ex) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(new IOException(ex));
            }
        }
    }

    @Override
    public StreamConnection performUpgrade() throws IOException {
        throw UndertowMessages.MESSAGES.upgradeNotSupported();
    }

    @Override
    public Pool<ByteBuffer> getBufferPool() {
        return this.spdyChannel.getBufferPool();
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.spdyChannel.getPeerAddress();
    }

    @Override
    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return this.spdyChannel.getPeerAddress(type);
    }

    @Override
    public ChannelListener.Setter<? extends ClientConnection> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.spdyChannel.getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return this.spdyChannel.getLocalAddress(type);
    }

    @Override
    public XnioWorker getWorker() {
        return this.spdyChannel.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.spdyChannel.getIoThread();
    }

    @Override
    public boolean isOpen() {
        return this.spdyChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.spdyChannel.close();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return false;
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return null;
    }

    @Override
    public boolean isUpgraded() {
        return false;
    }

    private class SpdyRecieveListener
    implements ChannelListener<SpdyChannel> {
        private SpdyRecieveListener() {
        }

        @Override
        public void handleEvent(SpdyChannel channel) {
            block7: {
                try {
                    SpdyStreamSourceChannel result = (SpdyStreamSourceChannel)channel.receive();
                    if (result instanceof SpdySynReplyStreamSourceChannel) {
                        SpdyClientExchange request = (SpdyClientExchange)SpdyClientConnection.this.currentExchanges.remove(((SpdySynReplyStreamSourceChannel)result).getStreamId());
                        if (request == null) {
                            IoUtils.safeClose((Closeable)SpdyClientConnection.this);
                            return;
                        }
                        request.responseReady((SpdySynReplyStreamSourceChannel)result);
                        break block7;
                    }
                    if (!(result instanceof SpdyPingStreamSourceChannel)) break block7;
                    this.handlePing((SpdyPingStreamSourceChannel)result);
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                    IoUtils.safeClose((Closeable)SpdyClientConnection.this);
                    for (Map.Entry entry : SpdyClientConnection.this.currentExchanges.entrySet()) {
                        try {
                            ((SpdyClientExchange)entry.getValue()).failed(e);
                        }
                        catch (Exception ex) {
                            UndertowLogger.REQUEST_IO_LOGGER.ioException(new IOException(ex));
                        }
                    }
                }
            }
        }

        private void handlePing(SpdyPingStreamSourceChannel frame) {
            int id = frame.getId();
            if (id % 2 == 0) {
                frame.getSpdyChannel().sendPing(id);
            }
        }
    }
}

