/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

public class Context {
    private volatile Status status;
    private final String path;
    private final String jvmRoute;
    private final long hostid;
    private final long nbRequests;

    Context(ContextBuilder b) {
        this.status = b.status;
        this.path = b.path;
        this.jvmRoute = b.jvmRoute;
        this.hostid = b.hostid;
        this.nbRequests = b.nbRequests;
    }

    public boolean isEnabled() {
        return this.status == Status.ENABLED;
    }

    public boolean isDisabled() {
        return this.status == Status.DISABLED;
    }

    public boolean isStopped() {
        return this.status == Status.STOPPED;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String toString() {
        return "Context[Path: " + this.path + ", Status: " + (Object)((Object)this.status) + ", Node: " + this.jvmRoute + ", Host: " + this.hostid + "]";
    }

    public String getPath() {
        return this.path;
    }

    public String getJvmRoute() {
        return this.jvmRoute;
    }

    public long getHostid() {
        return this.hostid;
    }

    public long getNbRequests() {
        return this.nbRequests;
    }

    public static ContextBuilder builder() {
        return new ContextBuilder();
    }

    public static final class ContextBuilder {
        private Status status;
        private String path;
        private String jvmRoute;
        private long hostid;
        private long nbRequests;

        ContextBuilder() {
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setJvmRoute(String jvmRoute) {
            this.jvmRoute = jvmRoute;
        }

        public void setHostid(long hostid) {
            this.hostid = hostid;
        }

        public void setNbRequests(long nbRequests) {
            this.nbRequests = nbRequests;
        }

        public Status getStatus() {
            return this.status;
        }

        public String getPath() {
            return this.path;
        }

        public String getJvmRoute() {
            return this.jvmRoute;
        }

        public long getHostid() {
            return this.hostid;
        }

        public long getNbRequests() {
            return this.nbRequests;
        }

        public Context build() {
            return new Context(this);
        }
    }

    public static enum Status {
        ENABLED,
        DISABLED,
        STOPPED,
        REMOVED;

    }
}

