/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.UndertowLogger;
import io.undertow.client.UndertowClient;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.proxy.ProxyConnectionPool;
import io.undertow.server.handlers.proxy.mod_cluster.Balancer;
import io.undertow.server.handlers.proxy.mod_cluster.Context;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterLoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.mod_cluster.Node;
import io.undertow.server.handlers.proxy.mod_cluster.NodeConfig;
import io.undertow.server.handlers.proxy.mod_cluster.NodeState;
import io.undertow.server.handlers.proxy.mod_cluster.SessionId;
import io.undertow.server.handlers.proxy.mod_cluster.VHost;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import org.xnio.ssl.XnioSsl;

public class ModClusterContainer {
    private final List<Balancer> balancers = new CopyOnWriteArrayList<Balancer>();
    private final List<Node> nodes = new CopyOnWriteArrayList<Node>();
    private final List<Context> contexts = new CopyOnWriteArrayList<Context>();
    private final List<Node> failedNodes = new CopyOnWriteArrayList<Node>();
    private final List<VHost> hosts = new CopyOnWriteArrayList<VHost>();
    private final List<SessionId> sessionIds = Collections.synchronizedList(new ArrayList());
    private final Random random = new SecureRandom();
    private Timer timer;
    private final UndertowClient undertowClient;
    private final XnioSsl ssl;
    private volatile ModClusterLoadBalancingProxyClient proxyClient;

    public ModClusterContainer(UndertowClient undertowClient, XnioSsl ssl) {
        this.undertowClient = undertowClient;
        this.ssl = ssl;
    }

    public ModClusterContainer(UndertowClient undertowClient) {
        this(undertowClient, null);
    }

    public ModClusterContainer() {
        this(UndertowClient.getInstance(), null);
    }

    public synchronized void start() {
        this.timer = new Timer(true);
        this.startNewTimerTask(new NodeStatusChecker(), 500L);
        this.startNewTimerTask(new HealthChecker(), 5000L);
        this.startNewTimerTask(new MCMConfigBackgroundProcessor(), 5000L);
        this.proxyClient = new ModClusterLoadBalancingProxyClient(null, this);
    }

    public synchronized void stop() {
        this.timer.cancel();
        this.proxyClient = null;
    }

    public ModClusterLoadBalancingProxyClient getProxyClient() {
        return this.proxyClient;
    }

    public Node findNode(HttpServerExchange exchange) {
        for (Balancer balancer : this.balancers) {
            String id;
            Node node;
            Node node2;
            Map<String, Cookie> cookies = exchange.getRequestCookies();
            if (!balancer.isStickySession()) continue;
            if (cookies.containsKey(balancer.getStickySessionCookie()) && (node2 = this.findNodeBySessionId(cookies.get(balancer.getStickySessionCookie()).getValue())) != null && node2.getConnectionPool().available() != ProxyConnectionPool.AvailabilityType.PROBLEM && node2.getNodeState().isNodeUp()) {
                return node2;
            }
            if (!exchange.getPathParameters().containsKey(balancer.getStickySessionPath()) || (node = this.findNodeBySessionId(id = exchange.getPathParameters().get(balancer.getStickySessionPath()).getFirst())) == null || node.getConnectionPool().available() == ProxyConnectionPool.AvailabilityType.PROBLEM || !node.getNodeState().isNodeUp()) continue;
            return node;
        }
        return this.getNode();
    }

    public Node findNodeBySessionId(String sessionId) {
        int index = sessionId.indexOf(46);
        if (index == -1) {
            return null;
        }
        String route = sessionId.substring(index + 1);
        if ((index = route.indexOf(46)) != -1) {
            route = route.substring(0, index);
        }
        for (Node node : this.nodes) {
            if (!route.equals(node.getJvmRoute())) continue;
            return node;
        }
        return null;
    }

    private void startNewTimerTask(TimerTask task, long interval) {
        this.timer.schedule(task, interval, interval);
    }

    public int getActiveNodes() {
        return this.nodes.size();
    }

    private Node getNode(int n) {
        if (n >= this.nodes.size()) {
            return null;
        }
        int index = this.random.nextInt(this.nodes.size());
        Node node = this.nodes.get(index);
        return node.getNodeState().isNodeUp() ? node : this.getNode(n + 1);
    }

    public List<Balancer> getBalancers() {
        return this.balancers;
    }

    public Node getNodeBySessionid(String sessionid) {
        System.out.println("getNode: " + sessionid);
        return this.getNode();
    }

    public void printNodes() {
        if (this.nodes.isEmpty()) {
            UndertowLogger.ROOT_LOGGER.info("No nodes available");
            return;
        }
        StringBuilder sb = new StringBuilder("--> Available nodes : [");
        int i = 0;
        for (Node n : this.nodes) {
            sb.append(n.getNodeConfig().getHostname() + ":" + n.getNodeConfig().getPort());
            if (i++ >= this.nodes.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        UndertowLogger.ROOT_LOGGER.info(sb);
    }

    public Node getNodeBySessionid(String sessionid, Node failedNode) {
        if (failedNode != null) {
            UndertowLogger.ROOT_LOGGER.warn("The node [" + failedNode.getNodeConfig().getHostname() + ":" + failedNode.getNodeConfig().getPort() + "] is down");
            failedNode.getNodeState().setStatus(NodeState.NodeStatus.NODE_DOWN);
        }
        return this.getNodeBySessionid(sessionid);
    }

    public Node getNode(String jvmRoute) {
        for (Node nod : this.nodes) {
            if (!nod.getJvmRoute().equals(jvmRoute)) continue;
            return nod;
        }
        return null;
    }

    public Node getNode() {
        Node nodeConfig = null;
        for (Node nod : this.nodes) {
            if (nod.getNodeState().getStatus() == NodeState.NodeStatus.NODE_DOWN) continue;
            if (nodeConfig != null) {
                int status = (nodeConfig.getNodeState().getElected() - nodeConfig.getNodeState().getOldelected()) * 1000 / nodeConfig.getNodeState().getLoad();
                int status1 = (nod.getNodeState().getElected() - nod.getNodeState().getOldelected()) * 1000 / nod.getNodeState().getLoad();
                if (status1 <= status) continue;
                nodeConfig = nod;
                continue;
            }
            nodeConfig = nod;
        }
        if (nodeConfig != null) {
            nodeConfig.getNodeState().setElected(nodeConfig.getNodeState().getElected() + 1);
        }
        return nodeConfig;
    }

    public void insertupdate(NodeConfig nodeConfig) {
        if (this.nodes.isEmpty()) {
            this.nodes.add(new Node(nodeConfig, this, this.ssl, this.undertowClient));
        } else {
            int i = 1;
            Node replace = null;
            for (Node nod : this.nodes) {
                if (nod.getJvmRoute().equals(nodeConfig.getJvmRoute())) {
                    replace = nod;
                    break;
                }
                ++i;
            }
            if (replace != null) {
                replace.updateConfig(nodeConfig);
            } else {
                this.nodes.add(new Node(nodeConfig, this, this.ssl, this.undertowClient));
            }
        }
    }

    public void insertupdate(Balancer balancer) {
        if (this.getBalancers().isEmpty()) {
            this.getBalancers().add(balancer);
        } else {
            for (Balancer bal : this.getBalancers()) {
                if (!bal.getName().equals(balancer.getName())) continue;
                this.getBalancers().remove(bal);
                this.getBalancers().add(balancer);
                break;
            }
        }
    }

    public long insertupdate(VHost host) {
        int i = 1;
        if (this.hosts.isEmpty()) {
            host.setId(i);
            this.hosts.add(host);
            return 1L;
        }
        for (VHost hos : this.hosts) {
            if (hos.getJVMRoute().equals(host.getJVMRoute()) && this.isSame(host.getAliases(), hos.getAliases())) {
                return hos.getId();
            }
            ++i;
        }
        host.setId(i);
        this.hosts.add(host);
        return i;
    }

    private boolean isSame(List<String> aliases, List<String> aliases2) {
        if (aliases.size() != aliases2.size()) {
            return false;
        }
        for (String host : aliases) {
            if (aliases.contains(host)) continue;
            return false;
        }
        return true;
    }

    public void insertupdate(Context context) {
        if (this.contexts.isEmpty()) {
            this.contexts.add(context);
            return;
        }
        for (Context con : this.contexts) {
            if (!context.getJvmRoute().equals(con.getJvmRoute()) || context.getHostid() != con.getHostid() || !context.getPath().equals(con.getPath())) continue;
            con.setStatus(context.getStatus());
            return;
        }
        this.contexts.add(context);
    }

    public void checkHealthNode() {
        for (Node nod : this.nodes) {
            if (nod.getNodeState().getElected() == nod.getNodeState().getOldelected()) continue;
            nod.getNodeState().setOldelected(nod.getNodeState().getElected());
        }
    }

    public void remove(Context context, VHost host) {
        for (Context con : this.contexts) {
            if (!context.getJvmRoute().equals(con.getJvmRoute()) || !this.isSame(this.getHostById(con.getHostid()).getAliases(), host.getAliases()) || !context.getPath().equals(con.getPath())) continue;
            this.contexts.remove(con);
            this.removeEmptyHost(con.getHostid());
            return;
        }
    }

    private void removeEmptyHost(long hostid) {
        boolean remove = true;
        for (Context con : this.contexts) {
            if (con.getHostid() != hostid) continue;
            remove = false;
            break;
        }
        if (remove) {
            this.hosts.remove(this.getHostById(hostid));
        }
    }

    private VHost getHostById(long hostid) {
        for (VHost hos : this.hosts) {
            if (hos.getId() != hostid) continue;
            return hos;
        }
        return null;
    }

    public void removeNode(String jvmRoute) {
        ArrayList<Context> remcons = new ArrayList<Context>();
        for (Context con : this.contexts) {
            if (!con.getJvmRoute().equals(jvmRoute)) continue;
            remcons.add(con);
        }
        for (Context con : remcons) {
            this.contexts.remove(con);
        }
        ArrayList<VHost> remhosts = new ArrayList<VHost>();
        for (VHost hos : this.hosts) {
            if (!hos.getJVMRoute().equals(jvmRoute)) continue;
            remhosts.add(hos);
        }
        for (VHost hos : remhosts) {
            this.hosts.remove(hos);
        }
        ArrayList<Node> remnodes = new ArrayList<Node>();
        for (Node nod : this.nodes) {
            if (!nod.getJvmRoute().equals(jvmRoute)) continue;
            remnodes.add(nod);
        }
        for (Node nod : remnodes) {
            this.nodes.remove(nod);
        }
    }

    public List<SessionId> getSessionIds() {
        return this.sessionIds;
    }

    public String getJVMRouteSessionCount(String jvmRoute) {
        int i = 0;
        for (SessionId s : this.sessionIds) {
            if (!s.getJmvRoute().equals(jvmRoute)) continue;
            ++i;
        }
        return "" + i;
    }

    void scheduleTask(TimerTask task, int interval) {
        this.timer.schedule(task, interval, (long)interval);
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Context> getContexts() {
        return this.contexts;
    }

    public List<VHost> getHosts() {
        return this.hosts;
    }

    public long getNodeId(String jvmRoute) {
        Node node = this.getNode(jvmRoute);
        if (node != null) {
            return node.getId();
        }
        return -1L;
    }

    private class NodeStatusChecker
    extends TimerTask {
        private NodeStatusChecker() {
        }

        @Override
        public void run() {
            ArrayList<Node> tmp = new ArrayList<Node>();
            try {
                for (Node n : ModClusterContainer.this.nodes) {
                    if (!n.getNodeState().isNodeDown()) continue;
                    tmp.add(n);
                }
                if (tmp.isEmpty()) {
                    return;
                }
                ModClusterContainer.this.nodes.removeAll(tmp);
                ModClusterContainer.this.failedNodes.addAll(tmp);
                tmp.clear();
                for (Node n : ModClusterContainer.this.failedNodes) {
                    if (!n.getNodeState().isNodeUp()) continue;
                    tmp.add(n);
                }
                if (tmp.isEmpty()) {
                    return;
                }
                ModClusterContainer.this.failedNodes.removeAll(tmp);
                ModClusterContainer.this.nodes.addAll(tmp);
                tmp.clear();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private class HealthChecker
    extends TimerTask {
        private HealthChecker() {
        }

        @Override
        public void run() {
            ArrayList<Node> tmp = new ArrayList<Node>();
            if (ModClusterContainer.this.failedNodes.isEmpty()) {
                return;
            }
            UndertowLogger.ROOT_LOGGER.debug("Starting health check for previously failed nodes");
            for (Node nodeConfig : ModClusterContainer.this.failedNodes) {
                if (!this.checkHealth(nodeConfig)) continue;
                nodeConfig.getNodeState().setStatus(NodeState.NodeStatus.NODE_UP);
                tmp.add(nodeConfig);
            }
            if (tmp.isEmpty()) {
                return;
            }
            ModClusterContainer.this.nodes.addAll(tmp);
            ModClusterContainer.this.failedNodes.removeAll(tmp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean checkHealth(Node node) {
            if (node == null) {
                return false;
            }
            boolean ok = false;
            Socket s = null;
            try {
                s = new Socket(node.getNodeConfig().getHostname(), node.getNodeConfig().getPort());
                s.setSoLinger(true, 0);
                ok = true;
            }
            catch (Exception e) {
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception e) {}
                }
            }
            return ok;
        }
    }

    protected class MCMConfigBackgroundProcessor
    extends TimerTask {
        protected MCMConfigBackgroundProcessor() {
        }

        @Override
        public void run() {
            ModClusterContainer.this.checkHealthNode();
        }
    }
}

