/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.client.UndertowClient;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.ConnectionPoolManager;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.server.handlers.proxy.ProxyConnectionPool;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterContainer;
import io.undertow.server.handlers.proxy.mod_cluster.NodeConfig;
import io.undertow.server.handlers.proxy.mod_cluster.NodeState;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.xnio.OptionMap;
import org.xnio.ssl.XnioSsl;

public class Node {
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final int id;
    private final String jvmRoute;
    private final ModClusterContainer container;
    private final ConnectionPoolManager connectionPoolManager;
    private final XnioSsl xnioSsl;
    private final UndertowClient client;
    private final NodeState nodeState;
    private volatile NodeConfig nodeConfig;
    private volatile ProxyConnectionPool connectionPool;

    Node(NodeConfig nodeConfig, ModClusterContainer container, XnioSsl xnioSsl, UndertowClient client) {
        this.nodeConfig = nodeConfig;
        this.nodeState = new NodeState();
        this.xnioSsl = xnioSsl;
        this.client = client;
        this.id = counter.incrementAndGet();
        this.jvmRoute = nodeConfig.getJvmRoute();
        this.container = container;
        this.connectionPoolManager = new NodeConnectionPoolManager();
    }

    synchronized void updateConfig(NodeConfig config) {
        ProxyConnectionPool pool = this.connectionPool;
        this.connectionPool = null;
        pool.close();
        this.nodeConfig = config;
    }

    public NodeState getNodeState() {
        return this.nodeState;
    }

    public NodeConfig getNodeConfig() {
        return this.nodeConfig;
    }

    public int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyConnectionPool getConnectionPool() {
        if (this.connectionPool == null) {
            Node node = this;
            synchronized (node) {
                if (this.connectionPool == null) {
                    try {
                        this.connectionPool = new ProxyConnectionPool(this.connectionPoolManager, new URI(this.nodeConfig.getType(), null, this.nodeConfig.getHostname(), this.nodeConfig.getPort(), "/", "", ""), this.xnioSsl, this.client, OptionMap.EMPTY);
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.connectionPool;
    }

    public String getInfos(int pos) {
        return "Node: [" + pos + "],Name: " + this.nodeConfig.getJvmRoute() + "Balancer: " + this.nodeConfig.getBalancer() + ",LBGroup: " + this.nodeConfig.getDomain() + ",Host: " + this.nodeConfig.getHostname() + ",Port: " + this.nodeConfig.getPort() + ",Type: " + this.nodeConfig.getType() + ",Flushpackets: " + (this.nodeConfig.isFlushPackets() ? "On" : "Off") + ",Flushwait: " + this.nodeConfig.getFlushwait() + ",Ping: " + this.nodeConfig.getPing() + ",Smax: " + this.nodeConfig.getSmax() + ",Ttl: " + this.nodeConfig.getTtl() + ",Elected: " + this.nodeState.getElected() + ",Read: " + this.nodeState.getRead() + ",Transfered: " + this.nodeState.getTransfered() + ",Connected: " + this.nodeState.getConnected() + ",Load: " + this.nodeState.getLoad() + "\n";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Node: [x:y]").append("], Balancer: ").append(this.nodeConfig.getBalancer()).append(", JVMRoute: ").append(this.nodeConfig.getJvmRoute()).append(", Domain: [").append(this.nodeConfig.getDomain()).append("], Host: ").append(this.nodeConfig.getHostname()).append(", Port: ").append(this.nodeConfig.getPort()).append(", Type: ").append(this.nodeConfig.getType()).append(", flush-packets: ").append(this.nodeConfig.isFlushPackets() ? 1 : 0).append(", flush-wait: ").append(this.nodeConfig.getFlushwait()).append(", Ping: ").append(this.nodeConfig.getPing()).append(", smax: ").append(this.nodeConfig.getSmax()).append(", TTL: ").append(this.nodeConfig.getTtl()).append(", Timeout: ").append(this.nodeConfig.getTimeout());
        return sb.toString();
    }

    public String getJvmRoute() {
        return this.jvmRoute;
    }

    private class NodeConnectionPoolManager
    implements ConnectionPoolManager {
        private NodeConnectionPoolManager() {
        }

        @Override
        public boolean canCreateConnection(int connections, ProxyConnectionPool proxyConnectionPool) {
            return true;
        }

        @Override
        public void queuedConnectionFailed(ProxyClient.ProxyTarget proxyTarget, HttpServerExchange exchange, ProxyCallback<ProxyConnection> callback, long timeoutMills) {
            Node node = Node.this.container.findNode(exchange);
            if (node == null || node == Node.this) {
                callback.failed(exchange);
                return;
            }
            node.getConnectionPool().connect(proxyTarget, exchange, callback, timeoutMills, TimeUnit.MILLISECONDS, false);
        }

        @Override
        public int getProblemServerRetry() {
            return Node.this.nodeConfig.getPing();
        }
    }
}

