/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.framed;

import io.undertow.UndertowMessages;
import io.undertow.server.protocol.framed.AbstractFramedChannel;
import io.undertow.server.protocol.framed.AbstractFramedStreamSourceChannel;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.util.ImmediatePooled;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.Pooled;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public abstract class AbstractFramedStreamSinkChannel<C extends AbstractFramedChannel<C, R, S>, R extends AbstractFramedStreamSourceChannel<C, R, S>, S extends AbstractFramedStreamSinkChannel<C, R, S>>
implements StreamSinkChannel {
    private static final Pooled<ByteBuffer> EMPTY_BYTE_BUFFER = new ImmediatePooled<ByteBuffer>(ByteBuffer.allocateDirect(0));
    private final Pooled<ByteBuffer> buffer;
    private final C channel;
    private final ChannelListener.SimpleSetter<S> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<S> closeSetter = new ChannelListener.SimpleSetter();
    private final Object lock = new Object();
    private volatile int state = 0;
    private SendFrameHeader header;
    private Pooled<ByteBuffer> trailer;
    private static final int STATE_BROKEN = 1;
    private static final int STATE_READY_FOR_FLUSH = 2;
    private static final int STATE_CLOSED = 4;
    private static final int STATE_ACTIVE = 8;
    private static final int STATE_WRITES_RESUMED = 16;
    private static final int STATE_WRITES_SHUTDOWN = 32;
    private static final int STATE_IN_LISTENER_LOOP = 64;
    private static final int STATE_FULLY_FLUSHED = 128;
    private static final int STATE_FINAL_FRAME_QUEUED = 256;

    protected AbstractFramedStreamSinkChannel(C channel) {
        this.channel = channel;
        this.buffer = ((AbstractFramedChannel)channel).getBufferPool().allocate();
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, this);
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer(source, count, throughBuffer, this);
    }

    @Override
    public void suspendWrites() {
        this.state &= 0xFFFFFFEF;
        if (Bits.anyAreSet(this.state, 8)) {
            ((AbstractFramedChannel)this.channel).suspendWrites();
        }
    }

    final SendFrameHeader getFrameHeader() {
        if (this.header == null) {
            this.header = this.createFrameHeader();
            if (this.header == null) {
                this.header = new SendFrameHeader(0, null);
            }
        }
        return this.header;
    }

    protected int frameCanSend() {
        return this.buffer.getResource().remaining();
    }

    protected SendFrameHeader createFrameHeader() {
        return null;
    }

    final ByteBuffer getFrameFooter() {
        if (this.trailer == null) {
            this.trailer = this.createFrameFooter();
            if (this.trailer == null) {
                this.trailer = EMPTY_BYTE_BUFFER;
            }
        }
        return this.trailer.getResource();
    }

    protected Pooled<ByteBuffer> createFrameFooter() {
        return null;
    }

    @Override
    public void resumeWrites() {
        this.resumeWrites(false);
    }

    @Override
    public boolean isWriteResumed() {
        return Bits.anyAreSet(this.state, 16);
    }

    @Override
    public void wakeupWrites() {
        this.resumeWrites(true);
    }

    void resumeWrites(boolean wakeup) {
        this.state |= 0x10;
        if (Bits.anyAreSet(this.state, 8)) {
            if (wakeup) {
                ((AbstractFramedChannel)this.channel).wakeupWrites();
            } else {
                ((AbstractFramedChannel)this.channel).resumeWrites();
            }
        } else if (!Bits.anyAreSet(this.state, 64)) {
            this.getIoThread().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AbstractFramedStreamSinkChannel.this.state |= 64;
                    try {
                        do {
                            ChannelListener listener;
                            if ((listener = AbstractFramedStreamSinkChannel.this.getWriteListener()) == null || !AbstractFramedStreamSinkChannel.this.isWriteResumed()) {
                                return;
                            }
                            ChannelListeners.invokeChannelListener(AbstractFramedStreamSinkChannel.this, listener);
                        } while (Bits.allAreClear(AbstractFramedStreamSinkChannel.this.state, 15) && (Bits.anyAreSet(AbstractFramedStreamSinkChannel.this.state, 128) || ((ByteBuffer)AbstractFramedStreamSinkChannel.this.buffer.getResource()).hasRemaining()));
                    }
                    finally {
                        AbstractFramedStreamSinkChannel.this.state &= -65;
                    }
                }
            });
        }
    }

    @Override
    public void shutdownWrites() throws IOException {
        this.state |= 0x20;
        this.queueFinalFrame();
    }

    private void queueFinalFrame() throws IOException {
        if (Bits.allAreClear(this.state, 258)) {
            this.buffer.getResource().flip();
            this.state |= 0x102;
            ((AbstractFramedChannel)this.channel).queueFrame((AbstractFramedStreamSinkChannel)this);
        }
    }

    protected boolean isFinalFrameQueued() {
        return Bits.anyAreSet(this.state, 256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitWritable() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (Bits.anyAreSet(this.state, 5)) {
                return;
            }
            if (Bits.anyAreSet(this.state, 8)) {
                ((AbstractFramedChannel)this.channel).awaitWritable();
            } else if (Bits.anyAreSet(this.state, 2)) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitWritable(long l, TimeUnit timeUnit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (Bits.anyAreSet(this.state, 5)) {
                return;
            }
            if (Bits.anyAreSet(this.state, 8)) {
                ((AbstractFramedChannel)this.channel).awaitWritable(l, timeUnit);
            } else if (Bits.anyAreSet(this.state, 2)) {
                try {
                    if (Bits.anyAreSet(this.state, 5)) {
                        return;
                    }
                    this.lock.wait(timeUnit.toMillis(l));
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
        }
    }

    @Override
    public XnioExecutor getWriteThread() {
        return ((AbstractFramedChannel)this.channel).getIoThread();
    }

    public ChannelListener.Setter<? extends S> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<? extends S> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public XnioWorker getWorker() {
        return ((AbstractFramedChannel)this.channel).getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return ((AbstractFramedChannel)this.channel).getIoThread();
    }

    @Override
    public boolean flush() throws IOException {
        if (Bits.anyAreSet(this.state, 4)) {
            return true;
        }
        if (Bits.anyAreSet(this.state, 1)) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        if (Bits.anyAreSet(this.state, 128)) {
            this.state |= 4;
            return true;
        }
        if (Bits.anyAreSet(this.state, 32) && Bits.anyAreClear(this.state, 256)) {
            this.queueFinalFrame();
        }
        if (Bits.allAreSet(this.state, 8)) {
            ((AbstractFramedChannel)this.channel).flushSenders();
            if (Bits.allAreSet(this.state, 384)) {
                this.state |= 4;
                return true;
            }
        }
        return !Bits.allAreSet(this.state, 32);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        int state = this.state;
        if (Bits.anyAreSet(state, 2)) {
            this.flush();
            state = this.state;
        }
        if (Bits.anyAreSet(state, 2)) {
            return 0L;
        }
        if (Bits.anyAreSet(state, 37)) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        long copied = Buffers.copy(this.buffer.getResource(), srcs, offset, length);
        if (!this.buffer.getResource().hasRemaining()) {
            this.handleBufferFull();
        }
        return copied;
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int state = this.state;
        if (Bits.anyAreSet(state, 2)) {
            this.flush();
            state = this.state;
        }
        if (Bits.anyAreSet(state, 2)) {
            return 0;
        }
        if (Bits.anyAreSet(state, 37)) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        int copied = Buffers.copy(this.buffer.getResource(), src);
        if (!this.buffer.getResource().hasRemaining()) {
            this.handleBufferFull();
        }
        return copied;
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Channels.writeFinalBasic(this, srcs, offset, length);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs) throws IOException {
        return this.writeFinal(srcs, 0, srcs.length);
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Channels.writeFinalBasic(this, src);
    }

    private void handleBufferFull() throws IOException {
        if (Bits.allAreClear(this.state, 2)) {
            this.getBuffer().flip();
            this.state |= 2;
            ((AbstractFramedChannel)this.channel).queueFrame((AbstractFramedStreamSinkChannel)this);
        }
        if (Bits.anyAreSet(this.state, 8)) {
            ((AbstractFramedChannel)this.channel).flushSenders();
        }
    }

    protected abstract boolean isLastFrame();

    public boolean isReadyForFlush() {
        return Bits.anyAreSet(this.state, 2);
    }

    public boolean isWritesShutdown() {
        return Bits.anyAreSet(this.state, 32);
    }

    @Override
    public boolean isOpen() {
        return Bits.allAreClear(this.state, 4);
    }

    @Override
    public void close() throws IOException {
        this.state |= 4;
        this.buffer.free();
        ((AbstractFramedChannel)this.channel).close();
        this.wakeupWaiters();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return false;
    }

    @Override
    public <T> T getOption(Option<T> tOption) throws IOException {
        return null;
    }

    @Override
    public <T> T setOption(Option<T> tOption, T t) throws IllegalArgumentException, IOException {
        return null;
    }

    public ByteBuffer getBuffer() {
        return this.buffer.getResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void flushComplete() throws IOException {
        try {
            boolean channelClosed;
            this.state &= 0xFFFFFFF5;
            int remaining = this.header.getReminingInBuffer();
            boolean bl = channelClosed = Bits.anyAreSet(this.state, 256) && remaining == 0;
            if (remaining > 0) {
                this.buffer.getResource().limit(this.buffer.getResource().limit() + remaining);
            }
            if (channelClosed) {
                this.state |= 0x80;
                this.buffer.free();
            } else {
                this.buffer.getResource().compact();
            }
            this.header.getByteBuffer().free();
            this.trailer.free();
            this.header = null;
            this.trailer = null;
            final ChannelListener<S> closeListener = this.closeSetter.get();
            if (channelClosed && closeListener != null) {
                this.getIoThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        ChannelListeners.invokeChannelListener(AbstractFramedStreamSinkChannel.this, closeListener);
                    }
                });
            }
            if (this.isWriteResumed() && !channelClosed) {
                this.wakeupWrites();
            }
            this.handleFlushComplete();
        }
        finally {
            this.wakeupWaiters();
        }
    }

    protected void handleFlushComplete() {
    }

    public void markBroken() {
        ChannelListener<S> closeListener;
        ChannelListener<S> writeListener;
        this.state |= 1;
        this.wakeupWrites();
        this.wakeupWaiters();
        if (this.isWriteResumed() && (writeListener = this.writeSetter.get()) != null) {
            ChannelListeners.invokeChannelListener(this.getIoThread(), this, writeListener);
        }
        if ((closeListener = this.closeSetter.get()) != null) {
            ChannelListeners.invokeChannelListener(this.getIoThread(), this, closeListener);
        }
    }

    ChannelListener<? super S> getWriteListener() {
        return this.writeSetter.get();
    }

    void activated() {
        if (Bits.allAreClear(this.state, 8)) {
            this.state |= 8;
            if (this.isWriteResumed()) {
                ((AbstractFramedChannel)this.channel).resumeWrites();
            }
            this.wakeupWaiters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeupWaiters() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    protected boolean isActivated() {
        return Bits.anyAreSet(this.state, 8);
    }

    public C getChannel() {
        return this.channel;
    }
}

