/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.spdy;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.server.Connectors;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.spdy.SpdyServerConnection;
import io.undertow.server.protocol.spdy.SpdySslSessionInfo;
import io.undertow.spdy.SpdyChannel;
import io.undertow.spdy.SpdyPingStreamSourceChannel;
import io.undertow.spdy.SpdyStreamSourceChannel;
import io.undertow.spdy.SpdySynStreamStreamSourceChannel;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.URLUtils;
import java.io.Closeable;
import java.io.IOException;
import javax.net.ssl.SSLSession;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class SpdyReceiveListener
implements ChannelListener<SpdyChannel> {
    private static final HttpString METHOD = new HttpString(":method");
    private static final HttpString PATH = new HttpString(":path");
    private static final HttpString SCHEME = new HttpString(":scheme");
    private static final HttpString VERSION = new HttpString(":version");
    private static final HttpString HOST = new HttpString(":host");
    private final HttpHandler rootHandler;
    private final long maxEntitySize;
    private final OptionMap undertowOptions;
    private final String encoding;
    private final StringBuilder decodeBuffer = new StringBuilder();
    private final boolean allowEncodingSlash;
    private final int bufferSize;

    public SpdyReceiveListener(HttpHandler rootHandler, OptionMap undertowOptions, int bufferSize) {
        this.rootHandler = rootHandler;
        this.undertowOptions = undertowOptions;
        this.bufferSize = bufferSize;
        this.maxEntitySize = undertowOptions.get(UndertowOptions.MAX_ENTITY_SIZE, -1L);
        this.allowEncodingSlash = undertowOptions.get(UndertowOptions.ALLOW_ENCODED_SLASH, false);
        this.encoding = undertowOptions.get(UndertowOptions.DECODE_URL, true) ? undertowOptions.get(UndertowOptions.URL_CHARSET, "UTF-8") : null;
    }

    @Override
    public void handleEvent(SpdyChannel channel) {
        try {
            SpdyStreamSourceChannel frame = (SpdyStreamSourceChannel)channel.receive();
            if (frame == null) {
                return;
            }
            if (frame instanceof SpdyPingStreamSourceChannel) {
                this.handlePing((SpdyPingStreamSourceChannel)frame);
            } else if (frame instanceof SpdySynStreamStreamSourceChannel) {
                SpdySynStreamStreamSourceChannel dataChannel = (SpdySynStreamStreamSourceChannel)frame;
                SpdyServerConnection connection = new SpdyServerConnection(channel, dataChannel, this.undertowOptions, this.bufferSize);
                HttpServerExchange exchange = new HttpServerExchange(connection, dataChannel.getHeaders(), dataChannel.getResponseChannel().getHeaders(), this.maxEntitySize);
                exchange.setRequestScheme(exchange.getRequestHeaders().getFirst(SCHEME));
                exchange.setProtocol(new HttpString(exchange.getRequestHeaders().getFirst(VERSION)));
                exchange.setRequestMethod(new HttpString(exchange.getRequestHeaders().getFirst(METHOD)));
                exchange.getRequestHeaders().add(Headers.HOST, exchange.getRequestHeaders().getFirst(HOST));
                String path = exchange.getRequestHeaders().getFirst(PATH);
                SpdyReceiveListener.setRequestPath(exchange, path, this.encoding, this.allowEncodingSlash, this.decodeBuffer);
                SSLSession session = channel.getSslSession();
                if (session != null) {
                    connection.setSslSessionInfo(new SpdySslSessionInfo(channel));
                }
                Connectors.executeRootHandler(this.rootHandler, exchange);
            }
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            IoUtils.safeClose((Closeable)channel);
        }
    }

    private void handlePing(SpdyPingStreamSourceChannel frame) {
        int id = frame.getId();
        if (id % 2 == 1) {
            frame.getSpdyChannel().sendPing(id);
        }
    }

    private static void setRequestPath(HttpServerExchange exchange, String encodedPath, String charset, boolean allowEncodedSlash, StringBuilder decodeBuffer) {
        if (charset == null) {
            SpdyReceiveListener.setRequestPath(exchange, encodedPath);
        } else {
            boolean requiresDecode = false;
            for (int i = 0; i < encodedPath.length(); ++i) {
                char c = encodedPath.charAt(i);
                if (c == '?') {
                    String part = requiresDecode ? URLUtils.decode(encodedPath.substring(0, i), charset, allowEncodedSlash, decodeBuffer) : encodedPath.substring(0, i);
                    exchange.setRequestPath(part);
                    exchange.setRelativePath(part);
                    exchange.setRequestURI(part);
                    SpdyReceiveListener.handleQueryParameter(exchange, encodedPath, null, i + 1, decodeBuffer);
                    return;
                }
                if (c != '%') continue;
                requiresDecode = true;
            }
            String part = requiresDecode ? URLUtils.decode(encodedPath, charset, allowEncodedSlash, decodeBuffer) : encodedPath;
            exchange.setRequestPath(part);
            exchange.setRelativePath(part);
            exchange.setRequestURI(part);
        }
    }

    private static void setRequestPath(HttpServerExchange exchange, String path) {
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '?') continue;
            String part = path.substring(0, i);
            exchange.setRequestPath(part);
            exchange.setRelativePath(part);
            exchange.setRequestURI(part);
            SpdyReceiveListener.handleQueryParameter(exchange, path, null, i + 1, null);
            return;
        }
        exchange.setRequestPath(path);
        exchange.setRelativePath(path);
        exchange.setRequestURI(path);
    }

    private static void handleQueryParameter(HttpServerExchange exchange, String path, String charset, int start, StringBuilder decodeBuffer) {
        exchange.setQueryString(path.substring(start));
        String headerName = null;
        int currentPos = start;
        boolean decodeRequired = false;
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '=' && headerName == null) {
                headerName = path.substring(currentPos, i);
                if (charset != null && decodeRequired) {
                    headerName = URLUtils.decode(headerName, charset, true, decodeBuffer);
                }
                currentPos = i;
                decodeRequired = false;
                continue;
            }
            if (c == '&' && headerName != null) {
                String value = path.substring(currentPos, i);
                if (charset != null && decodeRequired) {
                    value = URLUtils.decode(value, charset, true, decodeBuffer);
                }
                exchange.addQueryParam(headerName, value);
                headerName = null;
                currentPos = i;
                decodeRequired = false;
                continue;
            }
            if (c != '%') continue;
            decodeRequired = true;
        }
        if (headerName != null) {
            String value = path.substring(currentPos);
            if (charset != null && decodeRequired) {
                value = URLUtils.decode(value, charset, true, decodeBuffer);
            }
            exchange.addQueryParam(headerName, value);
        } else if (currentPos != path.length()) {
            headerName = path.substring(currentPos);
            if (charset != null && decodeRequired) {
                headerName = URLUtils.decode(headerName, charset, true, decodeBuffer);
            }
            exchange.addQueryParam(headerName, "");
        }
    }
}

