/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.spdy;

import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.spdy.SpdyChannel;
import io.undertow.spdy.SpdyStreamSinkChannel;
import java.io.IOException;

public abstract class SpdyStreamStreamSinkChannel
extends SpdyStreamSinkChannel {
    private final int streamId;
    private int flowControlWindow;
    private int initialWindowSize;
    private SendFrameHeader header;

    SpdyStreamStreamSinkChannel(SpdyChannel channel, int streamId) {
        super(channel);
        this.streamId = streamId;
        this.initialWindowSize = this.flowControlWindow = channel.getInitialWindowSize();
    }

    public int getStreamId() {
        return this.streamId;
    }

    SendFrameHeader generateSendFrameHeader() {
        this.header = this.createFrameHeaderImpl();
        return this.header;
    }

    void clearHeader() {
        this.header = null;
    }

    @Override
    protected final SendFrameHeader createFrameHeader() {
        SendFrameHeader header = this.header;
        this.header = null;
        return header;
    }

    protected abstract SendFrameHeader createFrameHeaderImpl();

    protected synchronized int grabFlowControlBytes(int toSend) {
        int newWindowSize = ((SpdyChannel)this.getChannel()).getInitialWindowSize();
        int settingsDelta = newWindowSize - this.initialWindowSize;
        this.initialWindowSize = newWindowSize;
        this.flowControlWindow += settingsDelta;
        int min = Math.min(toSend, this.flowControlWindow);
        int actualBytes = ((SpdyChannel)this.getChannel()).grabFlowControlBytes(min);
        this.flowControlWindow -= actualBytes;
        if (actualBytes == 0) {
            this.suspendWritesInternal();
        }
        return actualBytes;
    }

    synchronized void updateFlowControlWindow(int delta) throws IOException {
        boolean exhausted = this.flowControlWindow == 0;
        this.flowControlWindow += delta;
        if (exhausted) {
            ((SpdyChannel)this.getChannel()).notifyFlowControlAllowed();
            if (this.isWriteResumed()) {
                this.resumeWritesInternal();
            }
        }
    }
}

