/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.predicate.Predicate;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.HttpString;
import io.undertow.util.PathTemplateMatch;
import io.undertow.util.PathTemplateMatcher;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class RoutingHandler
implements HttpHandler {
    private final Map<HttpString, PathTemplateMatcher<RoutingMatch>> matches = new CopyOnWriteMap<HttpString, PathTemplateMatcher<RoutingMatch>>();
    private volatile HttpHandler fallbackHandler = ResponseCodeHandler.HANDLE_404;
    private volatile HttpHandler invalidMethodHandler = ResponseCodeHandler.HANDLE_405;
    private final boolean rewriteQueryParameters;

    public RoutingHandler(boolean rewriteQueryParameters) {
        this.rewriteQueryParameters = rewriteQueryParameters;
    }

    public RoutingHandler() {
        this.rewriteQueryParameters = true;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        PathTemplateMatcher<RoutingMatch> matcher = this.matches.get(exchange.getRequestMethod());
        if (matcher == null) {
            this.invalidMethodHandler.handleRequest(exchange);
            return;
        }
        PathTemplateMatcher.PathMatchResult<RoutingMatch> match = matcher.match(exchange.getRelativePath());
        if (match == null) {
            this.fallbackHandler.handleRequest(exchange);
            return;
        }
        exchange.putAttachment(PathTemplateMatch.ATTACHMENT_KEY, match);
        if (this.rewriteQueryParameters) {
            for (Map.Entry entry : match.getParameters().entrySet()) {
                exchange.addQueryParam((String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (HandlerHolder handlerHolder : match.getValue().predicatedHandlers) {
            if (!handlerHolder.predicate.resolve(exchange)) continue;
            handlerHolder.handler.handleRequest(exchange);
            return;
        }
        if (match.getValue().defaultHandler != null) {
            match.getValue().defaultHandler.handleRequest(exchange);
        } else {
            this.fallbackHandler.handleRequest(exchange);
        }
    }

    public synchronized RoutingHandler add(String method, String template, HttpHandler handler) {
        return this.add(new HttpString(method), template, handler);
    }

    public synchronized RoutingHandler add(HttpString method, String template, HttpHandler handler) {
        RoutingMatch res;
        PathTemplateMatcher<RoutingMatch> matcher = this.matches.get(method);
        if (matcher == null) {
            matcher = new PathTemplateMatcher();
            this.matches.put(method, matcher);
        }
        if ((res = matcher.get(template)) == null) {
            res = new RoutingMatch();
            matcher.add(template, res);
        }
        res.defaultHandler = handler;
        return this;
    }

    public synchronized RoutingHandler add(String method, String template, Predicate predicate, HttpHandler handler) {
        return this.add(new HttpString(method), template, predicate, handler);
    }

    public synchronized RoutingHandler add(HttpString method, String template, Predicate predicate, HttpHandler handler) {
        RoutingMatch res;
        PathTemplateMatcher<RoutingMatch> matcher = this.matches.get(method);
        if (matcher == null) {
            matcher = new PathTemplateMatcher();
            this.matches.put(method, matcher);
        }
        if ((res = matcher.get(template)) == null) {
            res = new RoutingMatch();
            matcher.add(template, res);
        }
        res.predicatedHandlers.add(new HandlerHolder(predicate, handler));
        return this;
    }

    public HttpHandler getFallbackHandler() {
        return this.fallbackHandler;
    }

    public void setFallbackHandler(HttpHandler fallbackHandler) {
        this.fallbackHandler = fallbackHandler;
    }

    private static class HandlerHolder {
        final Predicate predicate;
        final HttpHandler handler;

        private HandlerHolder(Predicate predicate, HttpHandler handler) {
            this.predicate = predicate;
            this.handler = handler;
        }
    }

    private static class RoutingMatch {
        final List<HandlerHolder> predicatedHandlers = new CopyOnWriteArrayList<HandlerHolder>();
        volatile HttpHandler defaultHandler;

        private RoutingMatch() {
        }
    }
}

