/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

public class Balancer {
    private final String name;
    private final boolean stickySession;
    private final String stickySessionCookie;
    private final String stickySessionPath;
    private final boolean stickySessionRemove;
    private final boolean stickySessionForce;
    private final int waitWorker;
    private final int maxattempts;

    Balancer(BalancerBuilder b) {
        this.name = b.getName();
        this.stickySession = b.isStickySession();
        this.stickySessionCookie = b.getStickySessionCookie();
        this.stickySessionPath = b.getStickySessionPath();
        this.stickySessionRemove = b.isStickySessionRemove();
        this.stickySessionForce = b.isStickySessionForce();
        this.waitWorker = b.getWaitWorker();
        this.maxattempts = b.getMaxattempts();
    }

    public String getName() {
        return this.name;
    }

    public boolean isStickySession() {
        return this.stickySession;
    }

    public String getStickySessionCookie() {
        return this.stickySessionCookie;
    }

    public String getStickySessionPath() {
        return this.stickySessionPath;
    }

    public boolean isStickySessionRemove() {
        return this.stickySessionRemove;
    }

    public boolean isStickySessionForce() {
        return this.stickySessionForce;
    }

    public int getWaitWorker() {
        return this.waitWorker;
    }

    public int getMaxattempts() {
        return this.maxattempts;
    }

    public String toString() {
        return "balancer: Name: " + this.name + ", Sticky: " + (this.stickySession ? 1 : 0) + " [" + this.stickySessionCookie + "]/[" + this.stickySessionPath + "], remove: " + (this.stickySessionRemove ? 1 : 0) + ", force: " + (this.stickySessionForce ? 1 : 0) + ", Timeout: " + this.waitWorker + ", Maxtry: " + this.maxattempts;
    }

    static final BalancerBuilder builder() {
        return new BalancerBuilder();
    }

    public static final class BalancerBuilder {
        private String name;
        private boolean stickySession = true;
        private String stickySessionCookie = "JSESSIONID";
        private String stickySessionPath = "jsessionid";
        private boolean stickySessionRemove = false;
        private boolean stickySessionForce = true;
        private int waitWorker = 0;
        private int maxattempts = 1;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isStickySession() {
            return this.stickySession;
        }

        public void setStickySession(boolean stickySession) {
            this.stickySession = stickySession;
        }

        public String getStickySessionCookie() {
            return this.stickySessionCookie;
        }

        public void setStickySessionCookie(String stickySessionCookie) {
            this.stickySessionCookie = stickySessionCookie != null && stickySessionCookie.length() > 30 ? stickySessionCookie.substring(0, 30) : stickySessionCookie;
        }

        public String getStickySessionPath() {
            return this.stickySessionPath;
        }

        public void setStickySessionPath(String stickySessionPath) {
            this.stickySessionPath = stickySessionPath;
        }

        public boolean isStickySessionRemove() {
            return this.stickySessionRemove;
        }

        public void setStickySessionRemove(boolean stickySessionRemove) {
            this.stickySessionRemove = stickySessionRemove;
        }

        public boolean isStickySessionForce() {
            return this.stickySessionForce;
        }

        public void setStickySessionForce(boolean stickySessionForce) {
            this.stickySessionForce = stickySessionForce;
        }

        public int getWaitWorker() {
            return this.waitWorker;
        }

        public void setWaitWorker(int waitWorker) {
            this.waitWorker = waitWorker;
        }

        public int getMaxattempts() {
            return this.maxattempts;
        }

        public void setMaxattempts(int maxattempts) {
            this.maxattempts = maxattempts;
        }

        public Balancer build() {
            return new Balancer(this);
        }
    }
}

