/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

public class NodeConfig {
    private final String hostname;
    private final int port;
    private final String type;
    private final long id;
    private final String balancer;
    private final String domain;
    private final String jvmRoute;
    private boolean flushPackets;
    private final int flushwait;
    private final int ping;
    private final int smax;
    private final int ttl;
    private final int timeout;

    NodeConfig(NodeBuilder b) {
        this.hostname = b.hostname;
        this.port = b.port;
        this.type = b.type;
        this.id = b.id;
        this.balancer = b.balancer;
        this.domain = b.domain;
        this.jvmRoute = b.jvmRoute;
        this.flushPackets = b.flushPackets;
        this.flushwait = b.flushwait;
        this.ping = b.ping;
        this.smax = b.smax;
        this.ttl = b.ttl;
        this.timeout = b.timeout;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getType() {
        return this.type;
    }

    public long getId() {
        return this.id;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getFlushwait() {
        return this.flushwait;
    }

    public int getPing() {
        return this.ping;
    }

    public int getSmax() {
        return this.smax;
    }

    public int getTtl() {
        return this.ttl;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getBalancer() {
        return this.balancer;
    }

    public boolean isFlushPackets() {
        return this.flushPackets;
    }

    public void setFlushPackets(boolean flushPackets) {
        this.flushPackets = flushPackets;
    }

    public String getJvmRoute() {
        return this.jvmRoute;
    }

    public static NodeBuilder builder() {
        return new NodeBuilder();
    }

    public static enum NodeStatus {
        NODE_UP,
        NODE_DOWN,
        NODE_PAUSED;

    }

    public static class NodeBuilder {
        private String hostname;
        private int port;
        private String type;
        private long id;
        private String balancer = "mycluster";
        private String domain = "";
        private String jvmRoute;
        private boolean flushPackets = false;
        private int flushwait = 10;
        private int ping = 10000;
        private int smax;
        private int ttl = 60000;
        private int timeout = 0;
        private int elected;
        private NodeStatus status = NodeStatus.NODE_UP;
        private int oldelected;
        private long read;
        private long transfered;
        private int connected;
        private int load;

        NodeBuilder() {
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setId(long id) {
            this.id = id;
        }

        public void setStatus(NodeStatus status) {
            this.status = status;
        }

        public void setBalancer(String balancer) {
            this.balancer = balancer;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setJvmRoute(String jvmRoute) {
            this.jvmRoute = jvmRoute;
        }

        public void setFlushPackets(boolean flushPackets) {
            this.flushPackets = flushPackets;
        }

        public void setFlushwait(int flushwait) {
            this.flushwait = flushwait;
        }

        public void setPing(int ping) {
            this.ping = ping;
        }

        public void setSmax(int smax) {
            this.smax = smax;
        }

        public void setTtl(int ttl) {
            this.ttl = ttl;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public void setElected(int elected) {
            this.elected = elected;
        }

        public void setOldelected(int oldelected) {
            this.oldelected = oldelected;
        }

        public void setRead(long read) {
            this.read = read;
        }

        public void setTransfered(long transfered) {
            this.transfered = transfered;
        }

        public void setConnected(int connected) {
            this.connected = connected;
        }

        public void setLoad(int load) {
            this.load = load;
        }

        public NodeConfig build() {
            return new NodeConfig(this);
        }
    }
}

