/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.spdy;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.OpenListener;
import io.undertow.server.protocol.http.HttpOpenListener;
import io.undertow.server.protocol.spdy.SpdyReceiveListener;
import io.undertow.spdy.SpdyChannel;
import io.undertow.util.ImmediatePooled;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.npn.NextProtoNego;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.PushBackStreamSourceConduit;
import org.xnio.ssl.JsseXnioSsl;
import org.xnio.ssl.SslConnection;

public final class SpdyOpenListener
implements ChannelListener<StreamConnection>,
OpenListener {
    private static final String PROTOCOL_KEY = SpdyOpenListener.class.getName() + ".protocol";
    private static final String SPDY_3 = "spdy/3";
    private static final String SPDY_3_1 = "spdy/3.1";
    private static final String HTTP_1_1 = "http/1.1";
    private final Pool<ByteBuffer> bufferPool;
    private final Pool<ByteBuffer> heapBufferPool;
    private final int bufferSize;
    private volatile HttpHandler rootHandler;
    private volatile OptionMap undertowOptions;
    private final HttpOpenListener delegate;

    public SpdyOpenListener(Pool<ByteBuffer> pool, Pool<ByteBuffer> heapBufferPool, int bufferSize) {
        this(pool, heapBufferPool, OptionMap.EMPTY, bufferSize, null);
    }

    public SpdyOpenListener(Pool<ByteBuffer> pool, Pool<ByteBuffer> heapBufferPool, OptionMap undertowOptions, int bufferSize) {
        this(pool, heapBufferPool, undertowOptions, bufferSize, null);
    }

    public SpdyOpenListener(Pool<ByteBuffer> pool, Pool<ByteBuffer> heapBufferPool, int bufferSize, HttpOpenListener httpDelegate) {
        this(pool, heapBufferPool, OptionMap.EMPTY, bufferSize, httpDelegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpdyOpenListener(Pool<ByteBuffer> pool, Pool<ByteBuffer> heapBufferPool, OptionMap undertowOptions, int bufferSize, HttpOpenListener httpDelegate) {
        this.undertowOptions = undertowOptions;
        this.bufferPool = pool;
        this.bufferSize = bufferSize;
        this.delegate = httpDelegate;
        this.heapBufferPool = heapBufferPool;
        Pooled<ByteBuffer> buff = heapBufferPool.allocate();
        try {
            if (!buff.getResource().hasArray()) {
                throw UndertowMessages.MESSAGES.mustProvideHeapBuffer();
            }
        }
        finally {
            buff.free();
        }
    }

    @Override
    public void handleEvent(StreamConnection channel) {
        if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
            UndertowLogger.REQUEST_LOGGER.tracef("Opened connection with %s", (Object)channel.getPeerAddress());
        }
        final PotentialSPDYConnection potentialConnection = new PotentialSPDYConnection(channel);
        channel.getSourceChannel().setReadListener(potentialConnection);
        final SSLEngine sslEngine = JsseXnioSsl.getSslEngine((SslConnection)channel);
        String existing = (String)sslEngine.getSession().getValue(PROTOCOL_KEY);
        if (existing != null) {
            UndertowLogger.REQUEST_LOGGER.debug("Resuming existing session, not doing NPN negotiation");
            if (existing.equals(SPDY_3_1) || existing.equals(SPDY_3)) {
                SpdyChannel sc = new SpdyChannel(channel, this.bufferPool, new ImmediatePooled<ByteBuffer>(ByteBuffer.wrap(new byte[0])), this.heapBufferPool);
                sc.getReceiveSetter().set(new SpdyReceiveListener(this.rootHandler, this.getUndertowOptions(), this.bufferSize));
                sc.resumeReceives();
            } else {
                if (this.delegate == null) {
                    UndertowLogger.REQUEST_IO_LOGGER.couldNotInitiateSpdyConnection();
                    IoUtils.safeClose((Closeable)channel);
                    return;
                }
                channel.getSourceChannel().setReadListener((ChannelListener<? super ConduitStreamSourceChannel>)null);
                this.delegate.handleEvent(channel);
            }
        } else {
            NextProtoNego.put((SSLEngine)sslEngine, (NextProtoNego.Provider)new NextProtoNego.ServerProvider(){

                public void unsupported() {
                    potentialConnection.selected = SpdyOpenListener.HTTP_1_1;
                }

                public List<String> protocols() {
                    return Arrays.asList(SpdyOpenListener.SPDY_3_1, SpdyOpenListener.SPDY_3, SpdyOpenListener.HTTP_1_1);
                }

                public void protocolSelected(String s) {
                    sslEngine.getSession().putValue(PROTOCOL_KEY, s);
                    potentialConnection.selected = s;
                }
            });
            potentialConnection.handleEvent(channel.getSourceChannel());
        }
    }

    @Override
    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public void setRootHandler(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
        if (this.delegate != null) {
            this.delegate.setRootHandler(rootHandler);
        }
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public void setUndertowOptions(OptionMap undertowOptions) {
        if (undertowOptions == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("undertowOptions");
        }
        this.undertowOptions = undertowOptions;
    }

    @Override
    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    private class PotentialSPDYConnection
    implements ChannelListener<StreamSourceChannel> {
        private String selected;
        private final StreamConnection channel;

        private PotentialSPDYConnection(StreamConnection channel) {
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleEvent(StreamSourceChannel source) {
            Pooled<ByteBuffer> buffer = SpdyOpenListener.this.bufferPool.allocate();
            boolean free = true;
            try {
                while (true) {
                    int res;
                    if ((res = this.channel.getSourceChannel().read((ByteBuffer)buffer.getResource())) == -1) {
                        IoUtils.safeClose((Closeable)this.channel);
                        return;
                    }
                    ((ByteBuffer)buffer.getResource()).flip();
                    if (SpdyOpenListener.SPDY_3.equals(this.selected) || SpdyOpenListener.SPDY_3_1.equals(this.selected)) {
                        NextProtoNego.remove((SSLEngine)JsseXnioSsl.getSslEngine((SslConnection)this.channel));
                        SpdyChannel channel = new SpdyChannel(this.channel, (Pool<ByteBuffer>)SpdyOpenListener.this.bufferPool, buffer, SpdyOpenListener.this.heapBufferPool);
                        Integer idleTimeout = SpdyOpenListener.this.undertowOptions.get(UndertowOptions.IDLE_TIMEOUT);
                        if (idleTimeout != null && idleTimeout > 0) {
                            channel.setIdleTimeout(idleTimeout.intValue());
                        }
                        free = false;
                        channel.getReceiveSetter().set(new SpdyReceiveListener(SpdyOpenListener.this.rootHandler, SpdyOpenListener.this.getUndertowOptions(), SpdyOpenListener.this.bufferSize));
                        channel.resumeReceives();
                        return;
                    }
                    if (SpdyOpenListener.HTTP_1_1.equals(this.selected) || res > 0) {
                        NextProtoNego.remove((SSLEngine)JsseXnioSsl.getSslEngine((SslConnection)this.channel));
                        if (SpdyOpenListener.this.delegate == null) {
                            UndertowLogger.REQUEST_IO_LOGGER.couldNotInitiateSpdyConnection();
                            IoUtils.safeClose((Closeable)this.channel);
                            return;
                        }
                        this.channel.getSourceChannel().setReadListener((ChannelListener<? super ConduitStreamSourceChannel>)null);
                        if (res > 0) {
                            PushBackStreamSourceConduit pushBackStreamSourceConduit = new PushBackStreamSourceConduit(this.channel.getSourceChannel().getConduit());
                            this.channel.getSourceChannel().setConduit(pushBackStreamSourceConduit);
                            pushBackStreamSourceConduit.pushBack(buffer);
                            free = false;
                        }
                        SpdyOpenListener.this.delegate.handleEvent(this.channel);
                        return;
                    }
                    if (res == 0) {
                        this.channel.getSourceChannel().resumeReads();
                        return;
                    }
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)this.channel);
                return;
            }
            finally {
                if (free) {
                    buffer.free();
                }
            }
        }
    }
}

