/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.spdy;

import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.spdy.SpdyChannel;
import io.undertow.spdy.SpdyProtocolUtils;
import io.undertow.spdy.SpdyStreamStreamSinkChannel;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.ImmediatePooled;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import org.xnio.Pooled;

public class SpdySynStreamStreamSinkChannel
extends SpdyStreamStreamSinkChannel {
    private final HeaderMap headers;
    private boolean first = true;
    private final Deflater deflater;

    SpdySynStreamStreamSinkChannel(SpdyChannel channel, HeaderMap headers, int streamId, Deflater deflater) {
        super(channel, streamId);
        this.headers = headers;
        this.deflater = deflater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SendFrameHeader createFrameHeaderImpl() {
        int fcWindow = this.grabFlowControlBytes(this.getBuffer().remaining());
        if (fcWindow == 0 && this.getBuffer().hasRemaining()) {
            return new SendFrameHeader(this.getBuffer().remaining(), null);
        }
        Pooled<ByteBuffer> firstHeaderBuffer = ((SpdyChannel)this.getChannel()).getBufferPool().allocate();
        Pooled<ByteBuffer>[] allHeaderBuffers = null;
        ByteBuffer firstBuffer = firstHeaderBuffer.getResource();
        if (this.first) {
            this.first = false;
            int firstInt = Integer.MIN_VALUE | ((SpdyChannel)this.getChannel()).getSpdyVersion() << 16 | 1;
            SpdyProtocolUtils.putInt(firstBuffer, firstInt);
            SpdyProtocolUtils.putInt(firstBuffer, 0);
            HeaderMap headers = this.headers;
            SpdyProtocolUtils.putInt(firstBuffer, this.getStreamId());
            SpdyProtocolUtils.putInt(firstBuffer, 0);
            firstBuffer.put((byte)0);
            firstBuffer.put((byte)0);
            headers.remove(Headers.CONNECTION);
            headers.remove(Headers.KEEP_ALIVE);
            headers.remove(Headers.TRANSFER_ENCODING);
            allHeaderBuffers = this.createHeaderBlock(firstHeaderBuffer, allHeaderBuffers, firstBuffer, headers);
        }
        Pooled<ByteBuffer> currentPooled = allHeaderBuffers == null ? firstHeaderBuffer : allHeaderBuffers[allHeaderBuffers.length - 1];
        ByteBuffer currentBuffer = currentPooled.getResource();
        int remainingInBuffer = 0;
        if (this.getBuffer().remaining() > 0) {
            remainingInBuffer = this.getBuffer().remaining() - fcWindow;
            this.getBuffer().limit(this.getBuffer().position() + fcWindow);
            if (currentBuffer.remaining() < 8) {
                allHeaderBuffers = this.allocateAll(allHeaderBuffers, currentPooled);
                currentPooled = allHeaderBuffers[allHeaderBuffers.length - 1];
                currentBuffer = currentPooled.getResource();
            }
            SpdyProtocolUtils.putInt(currentBuffer, this.getStreamId());
            SpdyProtocolUtils.putInt(currentBuffer, ((this.isWritesShutdown() ? 1 : 0) << 24) + fcWindow);
        }
        if (allHeaderBuffers == null) {
            currentBuffer.flip();
            return new SendFrameHeader(remainingInBuffer, currentPooled);
        }
        int length = 0;
        for (int i = 0; i < allHeaderBuffers.length; ++i) {
            length += ((ByteBuffer)allHeaderBuffers[i].getResource()).position();
            ((ByteBuffer)allHeaderBuffers[i].getResource()).flip();
        }
        try {
            ByteBuffer newBuf = ByteBuffer.allocate(length);
            for (int i = 0; i < allHeaderBuffers.length; ++i) {
                newBuf.put(allHeaderBuffers[i].getResource());
            }
            newBuf.flip();
            SendFrameHeader sendFrameHeader = new SendFrameHeader(remainingInBuffer, new ImmediatePooled<ByteBuffer>(newBuf));
            return sendFrameHeader;
        }
        finally {
            for (int i = 0; i < allHeaderBuffers.length; ++i) {
                allHeaderBuffers[i].free();
            }
        }
    }

    @Override
    protected Deflater getDeflater() {
        return this.deflater;
    }
}

