/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.framed;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.conduits.IdleTimeoutConduit;
import io.undertow.server.protocol.framed.AbstractFramedStreamSinkChannel;
import io.undertow.server.protocol.framed.AbstractFramedStreamSourceChannel;
import io.undertow.server.protocol.framed.FrameHeaderData;
import io.undertow.server.protocol.framed.FramePriority;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.util.ReferenceCountedPooled;
import io.undertow.websockets.core.WebSocketLogger;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public abstract class AbstractFramedChannel<C extends AbstractFramedChannel<C, R, S>, R extends AbstractFramedStreamSourceChannel<C, R, S>, S extends AbstractFramedStreamSinkChannel<C, R, S>>
implements ConnectedChannel {
    private final StreamConnection channel;
    private final IdleTimeoutConduit idleTimeoutConduit;
    private final ChannelListener.SimpleSetter<C> closeSetter;
    private final ChannelListener.SimpleSetter<C> receiveSetter;
    private final Pool<ByteBuffer> bufferPool;
    private final FramePriority<C, R, S> framePriority;
    private final List<S> pendingFrames = new LinkedList<S>();
    private final Deque<S> heldFrames = new ArrayDeque<S>();
    private final Deque<S> newFrames = new ArrayDeque<S>();
    private volatile R receiver = null;
    private final List<R> receivers = new CopyOnWriteArrayList<R>();
    private boolean receivesSuspended = true;
    private volatile int readsBroken = 0;
    private volatile int writesBroken = 0;
    private static final AtomicIntegerFieldUpdater<AbstractFramedChannel> readsBrokenUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractFramedChannel.class, "readsBroken");
    private static final AtomicIntegerFieldUpdater<AbstractFramedChannel> writesBrokenUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractFramedChannel.class, "writesBroken");
    private ReferenceCountedPooled<ByteBuffer> readData = null;
    private final List<ChannelListener<C>> closeTasks = new CopyOnWriteArrayList<ChannelListener<C>>();

    protected AbstractFramedChannel(StreamConnection connectedStreamChannel, Pool<ByteBuffer> bufferPool, FramePriority<C, R, S> framePriority, Pooled<ByteBuffer> readData) {
        this.framePriority = framePriority;
        if (readData != null) {
            this.readData = new ReferenceCountedPooled<ByteBuffer>(readData, 1);
        }
        IdleTimeoutConduit idle = this.createIdleTimeoutChannel(connectedStreamChannel);
        connectedStreamChannel.getSourceChannel().setConduit(idle);
        connectedStreamChannel.getSinkChannel().setConduit(idle);
        this.idleTimeoutConduit = idle;
        this.channel = connectedStreamChannel;
        this.bufferPool = bufferPool;
        this.closeSetter = new ChannelListener.SimpleSetter();
        this.receiveSetter = new ChannelListener.SimpleSetter();
        this.channel.getSourceChannel().getReadSetter().set(null);
        this.channel.getSourceChannel().suspendReads();
        this.channel.getSourceChannel().getReadSetter().set(new FrameReadListener());
        connectedStreamChannel.getSinkChannel().getWriteSetter().set(new FrameWriteListener());
        connectedStreamChannel.getSinkChannel().getCloseSetter().set(new FrameCloseListener());
    }

    protected IdleTimeoutConduit createIdleTimeoutChannel(StreamConnection connectedStreamChannel) {
        return new IdleTimeoutConduit(connectedStreamChannel.getSinkChannel().getConduit(), connectedStreamChannel.getSourceChannel().getConduit());
    }

    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return this.channel.getLocalAddress(type);
    }

    @Override
    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.channel.getIoThread();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.channel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.channel.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IOException {
        return this.channel.setOption(option, value);
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.channel.getPeerAddress();
    }

    @Override
    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return this.channel.getPeerAddress(type);
    }

    public InetSocketAddress getSourceAddress() {
        return this.getPeerAddress(InetSocketAddress.class);
    }

    public InetSocketAddress getDestinationAddress() {
        return this.getLocalAddress(InetSocketAddress.class);
    }

    public synchronized R receive() throws IOException {
        boolean hasData;
        if (this.receiver != null) {
            return null;
        }
        if (this.isLastFrameReceived()) {
            this.channel.getSourceChannel().suspendReads();
            this.channel.getSourceChannel().shutdownReads();
            return null;
        }
        ReferenceCountedPooled<ByteBuffer> pooled = this.readData;
        if (pooled == null) {
            Pooled<ByteBuffer> buf = this.bufferPool.allocate();
            this.readData = pooled = new ReferenceCountedPooled<ByteBuffer>(buf, 1);
            hasData = false;
        } else {
            hasData = pooled.getResource().hasRemaining();
        }
        boolean forceFree = false;
        int read = 0;
        try {
            FrameHeaderData data;
            if (!hasData) {
                pooled.getResource().clear();
                read = this.channel.getSourceChannel().read(pooled.getResource());
                if (read == 0) {
                    forceFree = true;
                    R r = null;
                    return r;
                }
                if (read == -1) {
                    try {
                        this.channel.getSourceChannel().shutdownReads();
                    }
                    catch (IOException e) {
                        if (WebSocketLogger.REQUEST_LOGGER.isDebugEnabled()) {
                            WebSocketLogger.REQUEST_LOGGER.debugf((Throwable)e, "Connection closed with IOException when attempting to shut down reads", new Object[0]);
                        }
                        IoUtils.safeClose((Closeable)this.channel.getSourceChannel());
                        throw e;
                    }
                    forceFree = true;
                    this.lastDataRead();
                    R e = null;
                    return e;
                }
                pooled.getResource().flip();
            }
            if ((data = this.parseFrame(pooled.getResource())) != null) {
                Pooled<ByteBuffer> frameData;
                if (data.getFrameLength() > (long)pooled.getResource().remaining()) {
                    frameData = pooled.createView(pooled.getResource().duplicate());
                    pooled.getResource().position(pooled.getResource().limit());
                } else {
                    ByteBuffer buf = pooled.getResource().duplicate();
                    buf.limit((int)((long)buf.position() + data.getFrameLength()));
                    pooled.getResource().position((int)((long)pooled.getResource().position() + data.getFrameLength()));
                    frameData = pooled.createView(buf);
                }
                AbstractFramedStreamSourceChannel<?, ?, ?> existing = data.getExistingChannel();
                if (existing != null) {
                    if (data.getFrameLength() > (long)frameData.getResource().remaining()) {
                        this.receiver = existing;
                        if (!((AbstractFramedStreamSourceChannel)this.receiver).isReadResumed()) {
                            this.channel.getSourceChannel().suspendReads();
                        }
                    }
                    existing.dataReady(data, frameData);
                    R r = null;
                    return r;
                }
                boolean moreData = data.getFrameLength() > (long)frameData.getResource().remaining();
                R newChannel = this.createChannel(data, frameData);
                if (moreData) {
                    this.receiver = newChannel;
                }
                this.receivers.add(newChannel);
                R r = newChannel;
                return r;
            }
            R r = null;
            return r;
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_LOGGER.ioException(e);
            this.markReadsBroken(e);
            forceFree = true;
            throw e;
        }
        finally {
            if (this.readData != null && (!pooled.getResource().hasRemaining() || forceFree)) {
                pooled.free();
                this.readData = null;
            }
        }
    }

    protected void lastDataRead() {
    }

    protected abstract R createChannel(FrameHeaderData var1, Pooled<ByteBuffer> var2) throws IOException;

    protected abstract FrameHeaderData parseFrame(ByteBuffer var1) throws IOException;

    protected synchronized void recalculateHeldFrames() throws IOException {
        if (!this.heldFrames.isEmpty()) {
            this.framePriority.frameAdded(null, this.pendingFrames, this.heldFrames);
            this.flushSenders();
        }
    }

    protected synchronized void flushSenders() throws IOException {
        AbstractFramedStreamSinkChannel sinkChannel;
        Pooled<ByteBuffer> frameHeaderByteBuffer;
        long res;
        AbstractFramedStreamSinkChannel sender;
        int toSend = 0;
        while (!this.newFrames.isEmpty()) {
            AbstractFramedStreamSinkChannel frame = (AbstractFramedStreamSinkChannel)this.newFrames.poll();
            if (this.framePriority.insertFrame(frame, this.pendingFrames)) {
                if (this.heldFrames.isEmpty()) continue;
                this.framePriority.frameAdded(frame, this.pendingFrames, this.heldFrames);
                continue;
            }
            this.heldFrames.add(frame);
        }
        boolean finalFrame = false;
        ListIterator<S> it = this.pendingFrames.listIterator();
        while (it.hasNext() && (sender = (AbstractFramedStreamSinkChannel)it.next()).isReadyForFlush()) {
            ++toSend;
            if (!sender.isLastFrame()) continue;
            finalFrame = true;
        }
        if (toSend == 0) {
            return;
        }
        Buffer[] data = new ByteBuffer[toSend * 3];
        it = this.pendingFrames.listIterator();
        for (int j = 0; j < toSend; ++j) {
            AbstractFramedStreamSinkChannel next = (AbstractFramedStreamSinkChannel)it.next();
            SendFrameHeader frameHeader = next.getFrameHeader();
            Pooled<ByteBuffer> frameHeaderByteBuffer2 = frameHeader.getByteBuffer();
            data[j * 3] = frameHeaderByteBuffer2 != null ? frameHeaderByteBuffer2.getResource() : Buffers.EMPTY_BYTE_BUFFER;
            data[j * 3 + 1] = next.getBuffer();
            data[j * 3 + 2] = next.getFrameFooter();
        }
        long toWrite = Buffers.remaining(data);
        do {
            try {
                res = this.channel.getSinkChannel().write((ByteBuffer[])data);
            }
            catch (IOException e) {
                IoUtils.safeClose((Closeable)this.channel);
                this.markWritesBroken(e);
                throw e;
            }
        } while (res > 0L && (toWrite -= res) > 0L);
        for (int max = toSend; !(max <= 0 || (frameHeaderByteBuffer = (sinkChannel = (AbstractFramedStreamSinkChannel)this.pendingFrames.get(0)).getFrameHeader().getByteBuffer()) != null && frameHeaderByteBuffer.getResource().hasRemaining() || sinkChannel.getBuffer().hasRemaining() || sinkChannel.getFrameFooter().hasRemaining()); --max) {
            sinkChannel.flushComplete();
            this.pendingFrames.remove(sinkChannel);
        }
        if (!this.pendingFrames.isEmpty()) {
            ((AbstractFramedStreamSinkChannel)this.pendingFrames.get(0)).activated();
        }
        if (this.pendingFrames.isEmpty() && finalFrame) {
            this.channel.getSinkChannel().shutdownWrites();
            if (!this.channel.getSinkChannel().flush()) {
                this.channel.getSinkChannel().setWriteListener(ChannelListeners.flushingChannelListener(null, null));
                this.channel.getSinkChannel().resumeWrites();
            }
        }
    }

    void awaitWritable() throws IOException {
        this.channel.getSinkChannel().awaitWritable();
    }

    void awaitWritable(long time, TimeUnit unit) throws IOException {
        this.channel.getSinkChannel().awaitWritable(time, unit);
    }

    protected synchronized void queueFrame(S channel) throws IOException {
        assert (!this.newFrames.contains(channel));
        if (this.isWritesBroken() || !this.channel.getSinkChannel().isOpen()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        this.newFrames.add(channel);
        if (this.newFrames.peek() == channel) {
            this.flushSenders();
        }
    }

    protected abstract boolean isLastFrameReceived();

    protected abstract boolean isLastFrameSent();

    protected abstract void handleBrokenSourceChannel(Throwable var1);

    protected abstract void handleBrokenSinkChannel(Throwable var1);

    public ChannelListener.Setter<C> getReceiveSetter() {
        return this.receiveSetter;
    }

    public synchronized void suspendReceives() {
        this.receivesSuspended = true;
        if (this.receiver == null) {
            this.channel.getSourceChannel().suspendReads();
        }
    }

    public synchronized void resumeReceives() {
        this.receivesSuspended = false;
        if (this.receiver == null) {
            if (this.readData != null) {
                this.channel.getSourceChannel().wakeupReads();
            } else {
                this.channel.getSourceChannel().resumeReads();
            }
        }
    }

    public boolean isReceivesResumed() {
        return !this.receivesSuspended;
    }

    @Override
    public void close() throws IOException {
        IoUtils.safeClose((Closeable)this.channel);
        this.wakeupWrites();
    }

    public ChannelListener.Setter<? extends AbstractFramedChannel> getCloseSetter() {
        return this.closeSetter;
    }

    protected void markReadsBroken(Throwable cause) {
        if (readsBrokenUpdater.compareAndSet(this, 0, 1)) {
            this.handleBrokenSourceChannel(cause);
            IoUtils.safeClose((Closeable)this.channel.getSourceChannel());
            R receiver = this.receiver;
            if (receiver != null && ((AbstractFramedStreamSourceChannel)receiver).isReadResumed()) {
                ChannelListeners.invokeChannelListener(((AbstractFramedStreamSourceChannel)receiver).getIoThread(), receiver, ((ChannelListener.SimpleSetter)((AbstractFramedStreamSourceChannel)receiver).getReadSetter()).get());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markWritesBroken(Throwable cause) {
        if (writesBrokenUpdater.compareAndSet(this, 0, 1)) {
            this.handleBrokenSinkChannel(cause);
            IoUtils.safeClose((Closeable)this.channel.getSinkChannel());
            AbstractFramedChannel abstractFramedChannel = this;
            synchronized (abstractFramedChannel) {
                for (AbstractFramedStreamSinkChannel channel : this.pendingFrames) {
                    channel.markBroken();
                }
                this.pendingFrames.clear();
                for (AbstractFramedStreamSinkChannel channel : this.newFrames) {
                    channel.markBroken();
                }
                this.newFrames.clear();
                for (AbstractFramedStreamSinkChannel channel : this.heldFrames) {
                    channel.markBroken();
                }
                this.heldFrames.clear();
            }
        }
    }

    protected boolean isWritesBroken() {
        return writesBrokenUpdater.get(this) != 0;
    }

    protected boolean isReadsBroken() {
        return readsBrokenUpdater.get(this) != 0;
    }

    void resumeWrites() {
        this.channel.getSinkChannel().resumeWrites();
    }

    void suspendWrites() {
        this.channel.getSinkChannel().suspendWrites();
    }

    void wakeupWrites() {
        this.channel.getSinkChannel().wakeupWrites();
    }

    StreamSourceChannel getSourceChannel() {
        return this.channel.getSourceChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyFrameReadComplete(AbstractFramedStreamSourceChannel<C, R, S> channel) {
        AbstractFramedChannel abstractFramedChannel = this;
        synchronized (abstractFramedChannel) {
            if (this.isLastFrameReceived()) {
                IoUtils.safeClose((Closeable)this.channel.getSourceChannel());
            }
            this.receivers.remove(channel);
            if (channel == this.receiver) {
                this.receiver = null;
                if (this.receivesSuspended) {
                    this.channel.getSourceChannel().suspendReads();
                } else {
                    this.channel.getSourceChannel().wakeupReads();
                }
            }
        }
    }

    public void setIdleTimeout(long timeout) {
        this.idleTimeoutConduit.setIdleTimeout(timeout);
    }

    public long getIdleTimeout() {
        return this.idleTimeoutConduit.getIdleTimeout();
    }

    protected FramePriority<C, R, S> getFramePriority() {
        return this.framePriority;
    }

    public void addCloseTask(ChannelListener<C> task) {
        this.closeTasks.add(task);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ " + (this.receiver == null ? "No Receiver" : this.receiver.toString()) + " " + this.pendingFrames.toString() + " -- " + this.heldFrames.toString() + " -- " + this.newFrames.toString() + "]";
    }

    protected StreamConnection getUnderlyingConnection() {
        return this.channel;
    }

    private class FrameCloseListener
    implements ChannelListener<StreamSinkChannel> {
        private FrameCloseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(StreamSinkChannel c) {
            AbstractFramedChannel abstractFramedChannel;
            if (Thread.currentThread() != c.getIoThread()) {
                ChannelListeners.invokeChannelListener(c.getIoThread(), c, this);
                return;
            }
            AbstractFramedStreamSourceChannel receiver = AbstractFramedChannel.this.receiver;
            try {
                if (receiver != null && receiver.isOpen() && receiver.isReadResumed()) {
                    ChannelListeners.invokeChannelListener(receiver, ((ChannelListener.SimpleSetter)receiver.getReadSetter()).get());
                }
                abstractFramedChannel = AbstractFramedChannel.this;
                synchronized (abstractFramedChannel) {
                    for (AbstractFramedStreamSinkChannel channel : AbstractFramedChannel.this.pendingFrames) {
                        channel.markBroken();
                    }
                    for (AbstractFramedStreamSinkChannel channel : AbstractFramedChannel.this.newFrames) {
                        channel.markBroken();
                    }
                    for (AbstractFramedStreamSinkChannel channel : AbstractFramedChannel.this.heldFrames) {
                        channel.markBroken();
                    }
                }
            }
            finally {
                try {
                    for (ChannelListener task : AbstractFramedChannel.this.closeTasks) {
                        ChannelListeners.invokeChannelListener(AbstractFramedChannel.this, task);
                    }
                }
                finally {
                    abstractFramedChannel = AbstractFramedChannel.this;
                    synchronized (abstractFramedChannel) {
                        for (AbstractFramedStreamSourceChannel r : AbstractFramedChannel.this.receivers) {
                            IoUtils.safeClose((Closeable)r);
                        }
                        if (AbstractFramedChannel.this.readData != null) {
                            AbstractFramedChannel.this.readData.free();
                            AbstractFramedChannel.this.readData = null;
                        }
                    }
                    ChannelListeners.invokeChannelListener(AbstractFramedChannel.this, AbstractFramedChannel.this.closeSetter.get());
                }
            }
        }
    }

    private class FrameWriteListener
    implements ChannelListener<StreamSinkChannel> {
        private FrameWriteListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(StreamSinkChannel channel) {
            AbstractFramedChannel abstractFramedChannel = AbstractFramedChannel.this;
            synchronized (abstractFramedChannel) {
                for (AbstractFramedStreamSinkChannel sender : AbstractFramedChannel.this.pendingFrames) {
                    if (!sender.isWriteResumed()) continue;
                    ChannelListeners.invokeChannelListener(sender, sender.getWriteListener());
                }
                if (AbstractFramedChannel.this.pendingFrames.isEmpty()) {
                    channel.suspendWrites();
                }
            }
        }
    }

    private final class FrameReadListener
    implements ChannelListener<StreamSourceChannel> {
        private FrameReadListener() {
        }

        @Override
        public void handleEvent(StreamSourceChannel channel) {
            AbstractFramedStreamSourceChannel receiver = AbstractFramedChannel.this.receiver;
            if (receiver != null) {
                this.invokeReadListener(channel, receiver);
            } else {
                if (AbstractFramedChannel.this.isLastFrameReceived() || AbstractFramedChannel.this.receivesSuspended) {
                    channel.suspendReads();
                    return;
                }
                ChannelListener listener = AbstractFramedChannel.this.receiveSetter.get();
                if (listener != null) {
                    WebSocketLogger.REQUEST_LOGGER.debugf("Invoking receive listener", (Object)receiver);
                    ChannelListeners.invokeChannelListener(AbstractFramedChannel.this, listener);
                    if (AbstractFramedChannel.this.receiver != null) {
                        this.invokeReadListener(channel, AbstractFramedChannel.this.receiver);
                    }
                } else {
                    channel.suspendReads();
                }
            }
            if (AbstractFramedChannel.this.readData != null && channel.isOpen()) {
                ChannelListeners.invokeChannelListener(channel.getIoThread(), channel, this);
            }
        }

        private void invokeReadListener(StreamSourceChannel channel, R receiver) {
            ChannelListener listener = ((ChannelListener.SimpleSetter)((AbstractFramedStreamSourceChannel)receiver).getReadSetter()).get();
            if (listener != null) {
                WebSocketLogger.REQUEST_LOGGER.debugf("Invoking read listener %s on %s", (Object)listener, receiver);
                ChannelListeners.invokeChannelListener(receiver, listener);
            } else {
                WebSocketLogger.REQUEST_LOGGER.debugf("Suspending reads on channel %s due to no listener", receiver);
                channel.suspendReads();
            }
        }
    }
}

