/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.spdy;

import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.spdy.SpdyChannel;
import io.undertow.spdy.SpdyProtocolUtils;
import io.undertow.spdy.SpdyStreamStreamSinkChannel;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.ImmediatePooled;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Pooled;

public class SpdySynReplyStreamSinkChannel
extends SpdyStreamStreamSinkChannel {
    private final HeaderMap headers = new HeaderMap();
    private boolean first = true;
    private final Deflater deflater;
    private ChannelListener<SpdySynReplyStreamSinkChannel> completionListener;

    SpdySynReplyStreamSinkChannel(SpdyChannel channel, int streamId, Deflater deflater) {
        super(channel, streamId);
        this.deflater = deflater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SendFrameHeader createFrameHeaderImpl() {
        int fcWindow = this.grabFlowControlBytes(this.getBuffer().remaining());
        if (fcWindow == 0 && this.getBuffer().hasRemaining()) {
            return new SendFrameHeader(this.getBuffer().remaining(), null);
        }
        Pooled<ByteBuffer> firstHeaderBuffer = ((SpdyChannel)this.getChannel()).getBufferPool().allocate();
        Pooled<ByteBuffer>[] allHeaderBuffers = null;
        ByteBuffer firstBuffer = firstHeaderBuffer.getResource();
        if (this.first) {
            this.first = false;
            int firstInt = Integer.MIN_VALUE | ((SpdyChannel)this.getChannel()).getSpdyVersion() << 16 | 2;
            SpdyProtocolUtils.putInt(firstBuffer, firstInt);
            SpdyProtocolUtils.putInt(firstBuffer, 0);
            HeaderMap headers = this.headers;
            SpdyProtocolUtils.putInt(firstBuffer, this.getStreamId());
            headers.remove(Headers.CONNECTION);
            headers.remove(Headers.KEEP_ALIVE);
            headers.remove(Headers.TRANSFER_ENCODING);
            allHeaderBuffers = this.createHeaderBlock(firstHeaderBuffer, allHeaderBuffers, firstBuffer, headers);
        }
        Pooled<ByteBuffer> currentPooled = allHeaderBuffers == null ? firstHeaderBuffer : allHeaderBuffers[allHeaderBuffers.length - 1];
        ByteBuffer currentBuffer = currentPooled.getResource();
        int remainingInBuffer = 0;
        if (this.getBuffer().remaining() > 0) {
            if (fcWindow > 0) {
                if (currentBuffer.remaining() < 8) {
                    currentPooled = (allHeaderBuffers = this.createHeaderBlock(firstHeaderBuffer, allHeaderBuffers, firstBuffer, this.headers)) == null ? firstHeaderBuffer : allHeaderBuffers[allHeaderBuffers.length - 1];
                    currentBuffer = currentPooled.getResource();
                }
                remainingInBuffer = this.getBuffer().remaining() - fcWindow;
                this.getBuffer().limit(this.getBuffer().position() + fcWindow);
                SpdyProtocolUtils.putInt(currentBuffer, this.getStreamId());
                SpdyProtocolUtils.putInt(currentBuffer, ((this.isWritesShutdown() ? 1 : 0) << 24) + fcWindow);
            } else {
                remainingInBuffer = this.getBuffer().remaining();
            }
        }
        if (allHeaderBuffers == null) {
            currentBuffer.flip();
            return new SendFrameHeader(remainingInBuffer, currentPooled);
        }
        int length = 0;
        for (int i = 0; i < allHeaderBuffers.length; ++i) {
            length += allHeaderBuffers[i].getResource().position();
            allHeaderBuffers[i].getResource().flip();
        }
        try {
            ByteBuffer newBuf = ByteBuffer.allocate(length);
            for (int i = 0; i < allHeaderBuffers.length; ++i) {
                newBuf.put(allHeaderBuffers[i].getResource());
            }
            newBuf.flip();
            SendFrameHeader sendFrameHeader = new SendFrameHeader(remainingInBuffer, new ImmediatePooled<ByteBuffer>(newBuf));
            return sendFrameHeader;
        }
        finally {
            for (int i = 0; i < allHeaderBuffers.length; ++i) {
                allHeaderBuffers[i].free();
            }
        }
    }

    @Override
    protected Deflater getDeflater() {
        return this.deflater;
    }

    public HeaderMap getHeaders() {
        return this.headers;
    }

    @Override
    protected void handleFlushComplete() {
        if (this.isFinalFrameQueued()) {
            ((SpdyChannel)this.getChannel()).removeStreamSink(this.getStreamId());
            if (this.completionListener != null) {
                ChannelListeners.invokeChannelListener(this, this.completionListener);
            }
        }
    }

    public ChannelListener<SpdySynReplyStreamSinkChannel> getCompletionListener() {
        return this.completionListener;
    }

    public void setCompletionListener(ChannelListener<SpdySynReplyStreamSinkChannel> completionListener) {
        this.completionListener = completionListener;
    }
}

